
;CodeVisionAVR C Compiler V3.12 Advanced
;(C) Copyright 1998-2014 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Build configuration    : Release
;Chip type              : ATmega8L
;Program type           : Application
;Clock frequency        : 8,000000 MHz
;Memory model           : Small
;Optimize for           : Size
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External RAM size      : 0
;Data Stack size        : 256 byte(s)
;Heap size              : 0 byte(s)
;Promote 'char' to 'int': Yes
;'char' is unsigned     : Yes
;8 bit enums            : Yes
;Global 'const' stored in FLASH: No
;Enhanced function parameter passing: Yes
;Enhanced core instructions: On
;Automatic register allocation for global variables: On
;Smart register allocation: On

	#define _MODEL_SMALL_

	#pragma AVRPART ADMIN PART_NAME ATmega8L
	#pragma AVRPART MEMORY PROG_FLASH 8192
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 1024
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0060
	.EQU __SRAM_END=0x045F
	.EQU __DSTACK_SIZE=0x0100
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTW2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	LDI  R24,BYTE3(2*@0+(@1))
	LDI  R25,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	PUSH R26
	PUSH R27
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	POP  R27
	POP  R26
	ICALL
	.ENDM

	.MACRO __CALL2EX
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	RCALL __EEPROMRDD
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R30,SPL
	IN   R31,SPH
	ADIW R30,@0+1
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1STACK
	IN   R30,SPL
	IN   R31,SPH
	ADIW R30,@0+1
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z
	MOVW R30,R0
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _m=R4
	.DEF _m_msb=R5
	.DEF _d=R6
	.DEF _d_msb=R7
	.DEF _n=R8
	.DEF _n_msb=R9
	.DEF _a=R10
	.DEF _a_msb=R11
	.DEF _tok=R12
	.DEF _tok_msb=R13

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _timer0_ovf_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_bolezni:
	.DB  0x73,0x74,0x65,0x6E,0x6F,0x6B,0x61,0x72
	.DB  0x64,0x69,0x79,0x61,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x0,0x49,0x42,0x53,0x3A,0x73,0x74
	.DB  0x65,0x6E,0x6F,0x6B,0x61,0x72,0x64,0x20
	.DB  0x73,0x20,0x67,0x69,0x70,0x65,0x72,0x74
	.DB  0x6F,0x6E,0x2E,0x0,0x49,0x42,0x53,0x3A
	.DB  0x6F,0x73,0x74,0x72,0x79,0x20,0x69,0x6E
	.DB  0x66,0x61,0x72,0x6B,0x74,0x20,0x20,0x6D
	.DB  0x69,0x6F,0x6B,0x2E,0x20,0x0,0x49,0x42
	.DB  0x53,0x3A,0x70,0x6F,0x73,0x74,0x69,0x6E
	.DB  0x66,0x2E,0x6B,0x61,0x72,0x64,0x69,0x6F
	.DB  0x73,0x6B,0x6C,0x65,0x72,0x2E,0x20,0x0
	.DB  0x49,0x42,0x53,0x3A,0x73,0x74,0x2C,0x6E
	.DB  0x65,0x64,0x2E,0x6B,0x72,0x6F,0x76,0x6F
	.DB  0x6F,0x62,0x72,0x61,0x73,0x68,0x63,0x2E
	.DB  0x20,0x0,0x49,0x42,0x53,0x3A,0x73,0x74
	.DB  0x2C,0x6B,0x61,0x72,0x64,0x69,0x6F,0x73
	.DB  0x6B,0x6C,0x2C,0x67,0x69,0x70,0x65,0x72
	.DB  0x74,0x20,0x20,0x0,0x47,0x69,0x70,0x65
	.DB  0x72,0x74,0x6F,0x6E,0x69,0x63,0x68,0x2E
	.DB  0x20,0x62,0x6F,0x6C,0x65,0x7A,0x6E,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x0,0x47,0x69
	.DB  0x70,0x65,0x72,0x74,0x2E,0x73,0x20,0x65
	.DB  0x6E,0x74,0x73,0x65,0x66,0x61,0x6C,0x6F
	.DB  0x70,0x61,0x74,0x2E,0x20,0x20,0x20,0x0
	.DB  0x4E,0x61,0x72,0x75,0x73,0x68,0x65,0x6E
	.DB  0x69,0x79,0x61,0x20,0x72,0x69,0x74,0x6D
	.DB  0x61,0x20,0x62,0x65,0x7A,0x20,0x49,0x42
	.DB  0x53,0x0,0x4D,0x69,0x6F,0x6B,0x61,0x72
	.DB  0x64,0x69,0x74,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x0,0x50,0x6F,0x72,0x6F
	.DB  0x6B,0x20,0x73,0x65,0x72,0x64,0x74,0x73
	.DB  0x61,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x0,0x50,0x6F
	.DB  0x72,0x6F,0x6B,0x20,0x73,0x65,0x72,0x64
	.DB  0x74,0x73,0x61,0x20,0x73,0x20,0x67,0x69
	.DB  0x70,0x65,0x72,0x74,0x6F,0x6E,0x20,0x0
	.DB  0x42,0x72,0x6F,0x6E,0x6B,0x68,0x69,0x61
	.DB  0x6C,0x6E,0x61,0x79,0x61,0x20,0x61,0x73
	.DB  0x74,0x6D,0x61,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x0,0x42,0x72,0x6F,0x6E,0x6B,0x68
	.DB  0x69,0x74,0x20,0x28,0x6F,0x73,0x74,0x72
	.DB  0x79,0x29,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x0,0x50,0x6E,0x65,0x76
	.DB  0x6D,0x6F,0x6E,0x69,0x79,0x61,0x2E,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x0,0x59,0x61
	.DB  0x7A,0x76,0x65,0x6E,0x6E,0x61,0x79,0x61
	.DB  0x20,0x62,0x6F,0x6C,0x65,0x7A,0x6E,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x0
	.DB  0x47,0x61,0x73,0x74,0x72,0x69,0x74,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x0,0x4B,0x68,0x6F,0x6C,0x65,0x74
	.DB  0x73,0x69,0x73,0x74,0x6F,0x2D,0x70,0x61
	.DB  0x6E,0x6B,0x72,0x65,0x61,0x74,0x69,0x74
	.DB  0x20,0x20,0x20,0x0,0x4B,0x6F,0x6C,0x69
	.DB  0x74,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x0,0x61,0x74
	.DB  0x65,0x72,0x6F,0x73,0x6B,0x6C,0x65,0x72
	.DB  0x6F,0x7A,0x20,0x73,0x6F,0x73,0x75,0x64
	.DB  0x6F,0x76,0x20,0x6D,0x6F,0x7A,0x67,0x0
	.DB  0x56,0x65,0x72,0x74,0x65,0x62,0x72,0x61
	.DB  0x6C,0x6E,0x6F,0x2D,0x62,0x61,0x7A,0x2E
	.DB  0x6E,0x65,0x64,0x6F,0x73,0x74,0x20,0x20
	.DB  0x20,0x0,0x4E,0x65,0x79,0x72,0x6F,0x2D
	.DB  0x74,0x73,0x69,0x72,0x6B,0x75,0x6C,0x79
	.DB  0x61,0x74,0x6F,0x72,0x6E,0x2E,0x64,0x69
	.DB  0x73,0x74,0x2E,0x0,0x70,0x6F,0x73,0x6C
	.DB  0x65,0x20,0x6E,0x61,0x72,0x2E,0x6D,0x6F
	.DB  0x7A,0x67,0x2E,0x6B,0x72,0x6F,0x76,0x6F
	.DB  0x6F,0x62,0x2E,0x20,0x20,0x0,0x52,0x61
	.DB  0x64,0x69,0x6B,0x75,0x6C,0x69,0x74,0x2C
	.DB  0x20,0x20,0x6E,0x65,0x76,0x72,0x69,0x74
	.DB  0x79,0x20,0x20,0x20,0x20,0x20,0x20,0x0
	.DB  0x4F,0x73,0x74,0x65,0x6F,0x6B,0x68,0x6F
	.DB  0x6E,0x64,0x72,0x6F,0x7A,0x20,0x70,0x6F
	.DB  0x7A,0x76,0x6F,0x6E,0x2E,0x20,0x20,0x20
	.DB  0x20,0x0,0x4E,0x65,0x76,0x72,0x6F,0x7A
	.DB  0x79,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x0,0x53,0x61,0x6B,0x68
	.DB  0x61,0x72,0x6E,0x79,0x20,0x64,0x69,0x61
	.DB  0x62,0x65,0x74,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x0,0x50,0x72
	.DB  0x6F,0x73,0x74,0x61,0x74,0x69,0x74,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x0
	.DB  0x41,0x64,0x65,0x6E,0x6F,0x6D,0x61,0x20
	.DB  0x70,0x72,0x6F,0x73,0x74,0x61,0x74,0x79
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x0,0x50,0x69,0x79,0x65,0x6C,0x6F
	.DB  0x6E,0x65,0x66,0x72,0x69,0x74,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x0,0x56,0x6F,0x73,0x70
	.DB  0x61,0x6C,0x69,0x74,0x65,0x6C,0x6E,0x79
	.DB  0x65,0x20,0x7A,0x61,0x62,0x6F,0x6C,0x65
	.DB  0x76,0x2E,0x20,0x20,0x20,0x0,0x4E,0x61
	.DB  0x72,0x75,0x73,0x68,0x2E,0x6D,0x65,0x6E
	.DB  0x73,0x74,0x72,0x75,0x61,0x6C,0x6E,0x6F
	.DB  0x67,0x6F,0x20,0x74,0x73,0x2E,0x20,0x0
	.DB  0x4E,0x65,0x79,0x72,0x6F,0x64,0x65,0x72
	.DB  0x6D,0x69,0x74,0x2C,0x20,0x65,0x6B,0x7A
	.DB  0x65,0x6D,0x61,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x0,0x50,0x73,0x6F,0x72,0x69,0x61
	.DB  0x7A,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x0,0x47,0x72,0x69,0x70
	.DB  0x70,0x2C,0x20,0x4F,0x52,0x56,0x49,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x0,0x54,0x6F
	.DB  0x6E,0x7A,0x69,0x6C,0x6C,0x69,0x74,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x0
	.DB  0x4B,0x68,0x69,0x72,0x75,0x72,0x67,0x69
	.DB  0x63,0x68,0x65,0x73,0x6B,0x61,0x79,0x61
	.DB  0x20,0x20,0x70,0x61,0x74,0x6F,0x6C,0x6F
	.DB  0x67,0x0,0x54,0x72,0x61,0x76,0x6D,0x61
	.DB  0x2C,0x76,0x20,0x74,0x6F,0x6D,0x20,0x63
	.DB  0x68,0x69,0x73,0x6C,0x65,0x20,0x6D,0x6E
	.DB  0x6F,0x7A,0x68,0x0,0x4F,0x7A,0x68,0x6F
	.DB  0x67,0x69,0x20,0x69,0x20,0x6F,0x74,0x6D
	.DB  0x6F,0x72,0x6F,0x7A,0x68,0x65,0x6E,0x69
	.DB  0x79,0x61,0x20,0x20,0x20,0x0,0x41,0x72
	.DB  0x74,0x72,0x69,0x74,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x0
	.DB  0x41,0x74,0x65,0x72,0x6F,0x73,0x6B,0x6C
	.DB  0x65,0x72,0x6F,0x7A,0x20,0x73,0x6F,0x73
	.DB  0x75,0x64,0x6F,0x76,0x20,0x6B,0x6F,0x6E
	.DB  0x2E,0x0,0x47,0x61,0x79,0x6D,0x6F,0x72
	.DB  0x69,0x74,0x2C,0x20,0x66,0x72,0x6F,0x6E
	.DB  0x74,0x69,0x74,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x0,0x50,0x65,0x72,0x69
	.DB  0x64,0x6F,0x6E,0x74,0x69,0x74,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x0,0x53,0x65
	.DB  0x6B,0x73,0x75,0x61,0x6C,0x6E,0x79,0x65
	.DB  0x20,0x20,0x72,0x61,0x73,0x73,0x74,0x72
	.DB  0x6F,0x79,0x73,0x74,0x76,0x61,0x20,0x0
	.DB  0x4E,0x61,0x72,0x75,0x73,0x68,0x65,0x6E
	.DB  0x69,0x79,0x61,0x20,0x72,0x65,0x63,0x68
	.DB  0x65,0x76,0x2E,0x20,0x72,0x61,0x7A,0x76
	.DB  0x20,0x0
_rezhimi:
	.DB  0x1,0x1,0x1,0x2,0x2,0x2,0x2,0x2
	.DB  0x3,0x3,0x1,0x1,0x1,0x2,0x2,0x2
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x2
	.DB  0x2,0x3,0x2,0x3,0x3,0x3,0x3,0x3
	.DB  0x1,0x2,0x2,0x3,0x3,0x3,0x3,0x3
	.DB  0x1,0x1,0x1,0x2,0x2,0x2,0x2,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x2,0x2,0x2
	.DB  0x2,0x1,0x1,0x1,0x3,0x3,0x1,0x2
	.DB  0x2,0x2,0x1,0x3,0x3,0x3,0x3,0x3
	.DB  0x1,0x2,0x2,0x2,0x1,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1
	.DB  0x1,0x1,0x1,0x2,0x2,0x3,0x3,0x3
	.DB  0x3,0x1,0x1,0x1,0x1,0x2,0x2,0x3
	.DB  0x1,0x1,0x1,0x1,0x2,0x2,0x1,0x2
	.DB  0x3,0x3,0x1,0x1,0x1,0x1,0x2,0x2
	.DB  0x1,0x2,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x1,0x1,0x1,0x2,0x1
	.DB  0x3,0x3,0x3,0x3,0x3,0x1,0x1,0x1
	.DB  0x2,0x1,0x3,0x3,0x1,0x1,0x1,0x2
	.DB  0x2,0x2,0x2,0x2,0x1,0x1,0x1,0x1
	.DB  0x1,0x2,0x2,0x2,0x2,0x2,0x1,0x1
	.DB  0x3,0x3,0x3,0x3,0x1,0x2,0x2,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x2
	.DB  0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x1,0x1,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x1,0x1,0x3,0x3,0x3
	.DB  0x1,0x1,0x2,0x2,0x2,0x1,0x1,0x1
	.DB  0x3,0x3,0x1,0x1,0x2,0x2,0x2,0x1
	.DB  0x1,0x1,0x3,0x3,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x2,0x2,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x2,0x2,0x1
	.DB  0x1,0x1,0x1,0x2,0x2,0x3,0x3,0x2
	.DB  0x2,0x3,0x1,0x1,0x1,0x2,0x2,0x3
	.DB  0x3,0x3,0x3,0x3,0x1,0x1,0x1,0x2
	.DB  0x2,0x2,0x2,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x2,0x2,0x2,0x2,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x2,0x2,0x1,0x2,0x1
	.DB  0x3,0x3,0x1,0x1,0x1,0x2,0x2,0x1
	.DB  0x2,0x1,0x3,0x3,0x3,0x3,0x1,0x2
	.DB  0x2,0x2,0x2,0x2,0x3,0x3,0x3,0x3
	.DB  0x1,0x2,0x2,0x2,0x2,0x2,0x3,0x3
	.DB  0x1,0x1,0x1,0x2,0x2,0x3,0x3,0x2
	.DB  0x1,0x1,0x1,0x1,0x1,0x2,0x2,0x3
	.DB  0x3,0x2,0x1,0x1,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x2,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x2,0x2,0x2,0x2,0x2,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x2,0x2
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x2,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x1,0x1,0x1,0x1
	.DB  0x2,0x2,0x2,0x2,0x2,0x2,0x1,0x1
	.DB  0x1,0x1,0x2,0x2,0x2,0x2,0x2,0x2
	.DB  0x3,0x3,0x1,0x1,0x2,0x2,0x2,0x2
	.DB  0x1,0x1,0x3,0x3,0x1,0x1,0x2,0x2
	.DB  0x2,0x2,0x1,0x1,0x3,0x3,0x3,0x3
	.DB  0x1,0x1,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x1,0x1,0x3,0x3,0x3,0x3
	.DB  0x1,0x1,0x2,0x2,0x2,0x2,0x3,0x3
	.DB  0x3,0x3,0x1,0x1,0x2,0x2,0x2,0x2
	.DB  0x3,0x3,0x3,0x3,0x1,0x2,0x2,0x2
	.DB  0x2,0x2,0x1,0x1,0x1,0x1,0x1,0x2
	.DB  0x2,0x2,0x2,0x2,0x3,0x3,0x1,0x1
	.DB  0x3,0x3,0x3,0x3,0x3,0x1,0x1,0x2
	.DB  0x2,0x2,0x3,0x3,0x3,0x3,0x3,0x1
	.DB  0x1,0x2,0x2,0x2,0x2,0x2,0x2,0x1
	.DB  0x1,0x3,0x3,0x3,0x2,0x2,0x2,0x2
	.DB  0x2,0x1,0x1,0x3,0x3,0x3,0x2,0x2
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x1,0x1,0x1,0x1,0x3,0x3,0x3,0x3
	.DB  0x1,0x2,0x1,0x2,0x2,0x2,0x3,0x3
	.DB  0x3,0x3,0x1,0x2,0x1,0x2,0x2,0x2
	.DB  0x1,0x1,0x2,0x2,0x2,0x2,0x2,0x2
	.DB  0x3,0x3,0x1,0x1,0x2,0x2,0x2,0x2
	.DB  0x2,0x2,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x2,0x1,0x2,0x2,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x2,0x1,0x2,0x2
	.DB  0x1,0x2,0x1,0x1,0x2,0x2,0x2,0x1
	.DB  0x1,0x1,0x1,0x2,0x1,0x1,0x2,0x2
	.DB  0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1
	.DB  0x3,0x3,0x3,0x1,0x2,0x2,0x1,0x1
	.DB  0x1,0x1,0x3,0x3,0x3,0x1,0x2,0x2
	.DB  0x1,0x1,0x2,0x2,0x2,0x2,0x2,0x1
	.DB  0x3,0x3,0x1,0x1,0x2,0x2,0x2,0x2
	.DB  0x2,0x1,0x3,0x3,0x2,0x2,0x2,0x2
	.DB  0x2,0x1,0x1,0x1,0x1,0x1,0x2,0x2
	.DB  0x2,0x2,0x2,0x1,0x1,0x1,0x1,0x1
	.DB  0x2,0x2,0x2,0x2,0x3,0x3,0x3,0x2
	.DB  0x1,0x1,0x2,0x2,0x2,0x2,0x3,0x3
	.DB  0x3,0x2,0x1,0x1,0x1,0x1,0x2,0x2
	.DB  0x3,0x3,0x3,0x3,0x2,0x1,0x1,0x1
	.DB  0x2,0x2,0x3,0x3,0x3,0x3,0x2,0x1
	.DB  0x1,0x1,0x1,0x1,0x1,0x2,0x2,0x2
	.DB  0x2,0x2,0x1,0x1,0x1,0x1,0x1,0x2
	.DB  0x2,0x2,0x2,0x2,0x1,0x1,0x1,0x1
	.DB  0x2,0x2,0x2,0x2,0x2,0x2,0x1,0x1
	.DB  0x3,0x3,0x3,0x3,0x3,0x2,0x2,0x2
	.DB  0x1,0x1,0x1,0x1,0x2,0x1,0x1,0x2
	.DB  0x2,0x2,0x1,0x1,0x1,0x1,0x2,0x1
	.DB  0x1,0x2,0x2,0x2,0x3,0x3,0x2,0x2
	.DB  0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x2,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3

;REGISTER BIT VARIABLES INITIALIZATION
__REG_BIT_VARS:
	.DW  0x0000

_0x3:
	.DB  0x30,0x2E,0x30
_0x4:
	.DB  0x1
_0x0:
	.DB  0x49,0x3D,0x30,0x2E,0x30,0x20,0x6D,0x41
	.DB  0x0,0x4C,0x6F,0x77,0x20,0x62,0x61,0x74
	.DB  0x74,0x0,0x42,0x61,0x74,0x74,0x65,0x72
	.DB  0x79,0x20,0x0,0x55,0x3D,0x0,0x20,0x76
	.DB  0x0,0x42,0x41,0x50,0x49,0x41,0x48,0x54
	.DB  0x32,0x20,0x0,0x33,0x41,0x48,0x4F,0x42
	.DB  0x4F,0x20,0x32,0x2D,0x48,0x45,0x54,0x2C
	.DB  0x2B,0x44,0x41,0x0,0x33,0x41,0x48,0x4F
	.DB  0x42,0x4F,0x20,0x31,0x2D,0x48,0x45,0x54
	.DB  0x2C,0x2B,0x44,0x41,0x0,0x20,0x20,0x4B
	.DB  0x79,0x70,0x63,0x20,0x20,0x20,0x33,0x41
	.DB  0x48,0x4F,0x42,0x4F,0x21,0x0,0x42,0x41
	.DB  0x50,0x49,0x41,0x48,0x54,0x0,0x43,0x45
	.DB  0x41,0x48,0x43,0x3D,0x20,0x0,0x20,0x50
	.DB  0x65,0x20,0x2D,0x20,0x0,0x32,0x20,0x4D
	.DB  0x6F,0x67,0x79,0x2D,0x31,0x30,0x6B,0x0
	.DB  0x33,0x20,0x54,0x70,0x65,0x79,0x2D,0x48
	.DB  0x65,0x4D,0x0,0x31,0x20,0x50,0x4F,0x42
	.DB  0x48,0x2D,0x48,0x65,0x4D,0x0,0x20,0x21
	.DB  0x20,0x48,0x45,0x54,0x20,0x20,0x4B,0x4F
	.DB  0x48,0x54,0x41,0x4B,0x54,0x41,0x0,0x49
	.DB  0x3D,0x0,0x30,0x2E,0x30,0x0,0x42,0x70
	.DB  0x2E,0x0,0x3A,0x0
_0x2000003:
	.DB  0x80,0xC0
_0x2040060:
	.DB  0x1
_0x2040000:
	.DB  0x2D,0x4E,0x41,0x4E,0x0,0x49,0x4E,0x46
	.DB  0x0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  0x02
	.DW  __REG_BIT_VARS*2

	.DW  0x03
	.DW  _tok0
	.DW  _0x3*2

	.DW  0x01
	.DW  _rezh0
	.DW  _0x4*2

	.DW  0x02
	.DW  __base_y_G100
	.DW  _0x2000003*2

	.DW  0x01
	.DW  __seed_G102
	.DW  _0x2040060*2

_0xFFFFFFFF:
	.DW  0

#define __GLOBAL_INI_TBL_PRESENT 1

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,__SRAM_START
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x160

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.03.9 Standard
;Automatic Program Generator
; Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version :
;Date    : 12.10.2010
;Author  :  
;Company :   ""
;Comments:
;
;
;Chip type               : ATmega8L
;Program type            : Application
;AVR Core Clock frequency: 8,000000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 256
;*****************************************************/
;
;#include <mega8.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;
;// Alphanumeric LCD Module functions
;#asm
   .equ __lcd_port=0x12 ;PORTD
; 0000 001D #endasm
;#include <lcd.h>
;#include <delay.h>
;#include <sleep.h>
;#include <stdlib.h>
;
;#define vihod PORTB.4
;//#define vhod DDRC.0
;#define napr PORTB.0
;#define dob PINB.6
;#define ubr PINB.7
;#define zvuk DDRB.1
;//#define svet PORTB.2
;#define kond PORTB.5
;
;//  
;flash char bolezni[45][26] = {"stenokardiya             ",
;"IBS:stenokard s giperton.",
;"IBS:ostry infarkt  miok. ",
;"IBS:postinf.kardioskler. ",
;"IBS:st,ned.krovoobrashc. ",
;"IBS:st,kardioskl,gipert  ",
;"Gipertonich. bolezn      ",
;"Gipert.s entsefalopat.   ",
;"Narusheniya ritma bez IBS",
;"Miokardit                ",
;"Porok serdtsa            ",
;"Porok serdtsa s giperton ",
;"Bronkhialnaya astma      ",
;"Bronkhit (ostry)         ",
;"Pnevmoniya.              ",
;"Yazvennaya bolezn        ",
;"Gastrit                  ",
;"Kholetsisto-pankreatit   ",
;"Kolit                    ",
;"ateroskleroz sosudov mozg",
;"Vertebralno-baz.nedost   ",
;"Neyro-tsirkulyatorn.dist.",
;"posle nar.mozg.krovoob.  ",
;"Radikulit,  nevrity      ",
;"Osteokhondroz pozvon.    ",
;"Nevrozy                  ",
;"Sakharny diabet          ",
;"Prostatit                ",
;"Adenoma prostaty         ",
;"Piyelonefrit             ",
;"Vospalitelnye zabolev.   ",
;"Narush.menstrualnogo ts. ",
;"Neyrodermit, ekzema      ",
;"Psoriaz                  ",
;"Gripp, ORVI              ",
;"Tonzillit                ",
;"Khirurgicheskaya  patolog",
;"Travma,v tom chisle mnozh",
;"Ozhogi i otmorozheniya   ",
;"Artrit                   ",
;"Ateroskleroz sosudov kon.",
;"Gaymorit, frontit        ",
;"Peridontit               ",
;"Seksualnye  rasstroystva ",
;"Narusheniya rechev. razv "};
;
;// 
;flash unsigned char rezhimi[45][20] = {{1,1,1,2,2,2,2,2,3,3,1,1,1,2,2,2,3,3,3,3},
;{3,3,1,2,2,3,2,3,3,3,3,3,1,2,2,3,3,3,3,3},
;{1,1,1,2,2,2,2,1,1,1,1,1,1,2,2,2,2,1,1,1},
;{3,3,1,2,2,2,1,3,3,3,3,3,1,2,2,2,1,3,3,3},
;{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
;{3,3,3,1,1,1,1,2,2,3,3,3,3,1,1,1,1,2,2,3},
;{1,1,1,1,2,2,1,2,3,3,1,1,1,1,2,2,1,2,3,3},
;{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
;{3,3,3,1,1,1,2,1,3,3,3,3,3,1,1,1,2,1,3,3},
;{1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1},
;{3,3,3,3,1,2,2,3,3,3,3,3,3,3,1,2,2,3,3,3},
;{3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,1,1,3,3,3},
;{1,1,2,2,2,1,1,1,3,3,1,1,2,2,2,1,1,1,3,3},
;{1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,2,2,1},
;{1,1,1,2,2,3,3,2,2,3,1,1,1,2,2,3,3,3,3,3},
;{1,1,1,2,2,2,2,1,1,1,1,1,1,2,2,2,2,1,1,1},
;{1,1,1,2,2,1,2,1,3,3,1,1,1,2,2,1,2,1,3,3},
;{3,3,1,2,2,2,2,2,3,3,3,3,1,2,2,2,2,2,3,3},
;{1,1,1,2,2,3,3,2,1,1,1,1,1,2,2,3,3,2,1,1},
;{3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3},
;{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
;{3,3,3,3,3,2,2,2,2,2,3,3,3,3,3,3,3,3,2,2},
;{3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3},
;{1,1,1,1,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2},
;{3,3,1,1,2,2,2,2,1,1,3,3,1,1,2,2,2,2,1,1},
;{3,3,3,3,1,1,3,3,3,3,3,3,3,3,1,1,3,3,3,3},
;{1,1,2,2,2,2,3,3,3,3,1,1,2,2,2,2,3,3,3,3},
;{1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,3,3,1,1},
;{3,3,3,3,3,1,1,2,2,2,3,3,3,3,3,1,1,2,2,2},
;{2,2,2,1,1,3,3,3,2,2,2,2,2,1,1,3,3,3,2,2},
;{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
;{3,3,3,3,1,2,1,2,2,2,3,3,3,3,1,2,1,2,2,2},
;{1,1,2,2,2,2,2,2,3,3,1,1,2,2,2,2,2,2,3,3},
;{3,3,3,3,3,3,2,1,2,2,3,3,3,3,3,3,2,1,2,2},
;{1,2,1,1,2,2,2,1,1,1,1,2,1,1,2,2,2,1,1,1},
;{1,1,1,1,3,3,3,1,2,2,1,1,1,1,3,3,3,1,2,2},
;{1,1,2,2,2,2,2,1,3,3,1,1,2,2,2,2,2,1,3,3},
;{2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1},
;{2,2,2,2,3,3,3,2,1,1,2,2,2,2,3,3,3,2,1,1},
;{1,1,2,2,3,3,3,3,2,1,1,1,2,2,3,3,3,3,2,1},
;{1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2},
;{1,1,1,1,2,2,2,2,2,2,1,1,3,3,3,3,3,2,2,2},
;{1,1,1,1,2,1,1,2,2,2,1,1,1,1,2,1,1,2,2,2},
;{3,3,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
;{3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3}};
;
;eeprom char seans1=0,seans2=0, bol1, bol2;
;unsigned int m,d,n,a,tok,time,time0;
;unsigned long paus;
;bit j,k,l,zad,k1,kluch,chel;
;unsigned char minut[3],sek[3],tok0[] = "0.0",vrem, rezh0=1, seans, bol, i;

	.DSEG
;float vrem0;
;
;#define ADC_VREF_TYPE 0xC0
;
;// Read the AD conversion result
;unsigned int read_adc(unsigned char adc_input)
; 0000 0095 {

	.CSEG
_read_adc:
; .FSTART _read_adc
; 0000 0096 ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
	ST   -Y,R26
;	adc_input -> Y+0
	LD   R30,Y
	ORI  R30,LOW(0xC0)
	OUT  0x7,R30
; 0000 0097 // Delay needed for the stabilization of the ADC input voltage
; 0000 0098 delay_us(10);
	__DELAY_USB 27
; 0000 0099 // Start the AD conversion
; 0000 009A ADCSRA|=0x40;
	SBI  0x6,6
; 0000 009B // Wait for the AD conversion to complete
; 0000 009C while ((ADCSRA & 0x10)==0);
_0x5:
	SBIS 0x6,4
	RJMP _0x5
; 0000 009D ADCSRA|=0x10;
	SBI  0x6,4
; 0000 009E return ADCW;
	IN   R30,0x4
	IN   R31,0x4+1
	RJMP _0x20C0004
; 0000 009F }
; .FEND
;
;
;// Timer 0 overflow interrupt service routine
;interrupt [TIM0_OVF] void timer0_ovf_isr(void)
; 0000 00A4 {
_timer0_ovf_isr:
; .FSTART _timer0_ovf_isr
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 00A5 // Place your code here
; 0000 00A6 if(zad++) TCNT0 = 0xBA;        //       10  70-90 ( )
	BST  R2,3
	LDI  R30,LOW(8)
	EOR  R2,R30
	LDI  R30,LOW(0)
	BLD  R30,0
	CPI  R30,0
	BREQ _0x8
	LDI  R30,LOW(186)
	OUT  0x32,R30
; 0000 00A7 else
	RJMP _0x9
_0x8:
; 0000 00A8 {
; 0000 00A9 
; 0000 00AA TCNT0=0x01;             //  
	LDI  R30,LOW(1)
	OUT  0x32,R30
; 0000 00AB 
; 0000 00AC   if (a++<83)              //     
	MOVW R30,R10
	ADIW R30,1
	MOVW R10,R30
	SBIW R30,1
	CPI  R30,LOW(0x53)
	LDI  R26,HIGH(0x53)
	CPC  R31,R26
	BRSH _0xA
; 0000 00AD  {
; 0000 00AE  if (k&(a<82)) vihod = !vihod; else vihod = 0;  //  10 
	LDI  R30,0
	SBRC R2,1
	LDI  R30,1
	MOV  R0,R30
	MOVW R26,R10
	LDI  R30,LOW(82)
	LDI  R31,HIGH(82)
	RCALL __LTW12U
	AND  R30,R0
	BREQ _0xB
	SBIS 0x18,4
	RJMP _0xC
	CBI  0x18,4
	RJMP _0xD
_0xC:
	SBI  0x18,4
_0xD:
	RJMP _0xE
_0xB:
	CBI  0x18,4
; 0000 00AF  }
_0xE:
; 0000 00B0  else
	RJMP _0x11
_0xA:
; 0000 00B1  {
; 0000 00B2  vihod = 1;                                     //  ,  2/3 .
	SBI  0x18,4
; 0000 00B3  };
_0x11:
; 0000 00B4  if (a == 83)                   //      
	LDI  R30,LOW(83)
	LDI  R31,HIGH(83)
	CP   R30,R10
	CPC  R31,R11
	BRNE _0x14
; 0000 00B5  {
; 0000 00B6  d = read_adc(0);         //  
	LDI  R26,LOW(0)
	RCALL _read_adc
	MOVW R6,R30
; 0000 00B7  zad++;                         // ?
	LDI  R30,LOW(8)
	EOR  R2,R30
; 0000 00B8     if (d > tok)                //     
	__CPWRR 12,13,6,7
	BRSH _0x15
; 0000 00B9     {
; 0000 00BA     napr = 1;
	RCALL SUBOPT_0x0
; 0000 00BB     TCCR1A=0x00;//32;                            //  
; 0000 00BC     m = 0;
	CLR  R4
	CLR  R5
; 0000 00BD     } else
	RJMP _0x18
_0x15:
; 0000 00BE     {
; 0000 00BF        if (m>220)
	LDI  R30,LOW(220)
	LDI  R31,HIGH(220)
	CP   R30,R4
	CPC  R31,R5
	BRSH _0x19
; 0000 00C0        {
; 0000 00C1        napr = 1;
	RCALL SUBOPT_0x0
; 0000 00C2        TCCR1A=0x00;//32;                  //  
; 0000 00C3        zvuk = !zvuk;             //    220 
	SBIS 0x17,1
	RJMP _0x1C
	CBI  0x17,1
	RJMP _0x1D
_0x1C:
	SBI  0x17,1
_0x1D:
; 0000 00C4 
; 0000 00C5 
; 0000 00C6        } else
	RJMP _0x1E
_0x19:
; 0000 00C7        {
; 0000 00C8         if (napr == 1)
	SBIS 0x18,0
	RJMP _0x1F
; 0000 00C9         {
; 0000 00CA         napr = 0;
	CBI  0x18,0
; 0000 00CB         TCCR1A=0x32;         //  
	LDI  R30,LOW(50)
	OUT  0x2F,R30
; 0000 00CC 
; 0000 00CD         };
_0x1F:
; 0000 00CE        };
_0x1E:
; 0000 00CF         if (m>440)
	LDI  R30,LOW(440)
	LDI  R31,HIGH(440)
	CP   R30,R4
	CPC  R31,R5
	BRSH _0x22
; 0000 00D0         {
; 0000 00D1         m=0;
	CLR  R4
	CLR  R5
; 0000 00D2         lcd_clear();
	RCALL _lcd_clear
; 0000 00D3         lcd_putsf("I=0.0 mA");
	__POINTW2FN _0x0,0
	RCALL _lcd_putsf
; 0000 00D4         lcd_gotoxy(0,1);
	RCALL SUBOPT_0x1
	LDI  R26,LOW(1)
	RCALL _lcd_gotoxy
; 0000 00D5         };            //   440 .  .
_0x22:
; 0000 00D6     m++;
	MOVW R30,R4
	ADIW R30,1
	MOVW R4,R30
; 0000 00D7     };
_0x18:
; 0000 00D8  };
_0x14:
; 0000 00D9 
; 0000 00DA 
; 0000 00DB if (a > n) a = 0;
	__CPWRR 8,9,10,11
	BRSH _0x23
	CLR  R10
	CLR  R11
; 0000 00DC };
_0x23:
_0x9:
; 0000 00DD }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
; .FEND
;
;void lcdbol(void)
; 0000 00E0 {
_lcdbol:
; .FSTART _lcdbol
; 0000 00E1         lcd_gotoxy(0,0);
	RCALL SUBOPT_0x1
	LDI  R26,LOW(0)
	RCALL _lcd_gotoxy
; 0000 00E2         itoa(bol,sek);
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x3
	RCALL SUBOPT_0x4
	RCALL _itoa
; 0000 00E3         if (bol<10) lcd_putchar('0');
	LDS  R26,_bol
	CPI  R26,LOW(0xA)
	BRSH _0x24
	LDI  R26,LOW(48)
	RCALL _lcd_putchar
; 0000 00E4         lcd_puts(sek);
_0x24:
	RCALL SUBOPT_0x4
	RCALL _lcd_puts
; 0000 00E5         lcd_gotoxy(2,0);
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R26,LOW(0)
	RCALL _lcd_gotoxy
; 0000 00E6         for (i = 0;i < 14;i++)     //     
	LDI  R30,LOW(0)
	STS  _i,R30
_0x26:
	LDS  R26,_i
	CPI  R26,LOW(0xE)
	BRSH _0x27
; 0000 00E7         {
; 0000 00E8            if(bolezni[bol][vrem+1] == 0)  //  
	RCALL SUBOPT_0x5
	LDI  R31,0
	ADIW R30,1
	RCALL SUBOPT_0x6
	LPM  R30,Z
	CPI  R30,0
	BRNE _0x28
; 0000 00E9            {
; 0000 00EA             vrem = 13;
	LDI  R30,LOW(13)
	RCALL SUBOPT_0x7
; 0000 00EB            // break;
; 0000 00EC            }
; 0000 00ED            else lcd_putchar(bolezni[bol][vrem++]);
	RJMP _0x29
_0x28:
	RCALL SUBOPT_0x5
	SUBI R30,-LOW(1)
	RCALL SUBOPT_0x7
	SUBI R30,LOW(1)
	LDI  R31,0
	RCALL SUBOPT_0x6
	LPM  R26,Z
	RCALL _lcd_putchar
; 0000 00EE         }
_0x29:
	LDS  R30,_i
	SUBI R30,-LOW(1)
	STS  _i,R30
	RJMP _0x26
_0x27:
; 0000 00EF         vrem -= 13;
	RCALL SUBOPT_0x8
	SUBI R30,LOW(13)
	RCALL SUBOPT_0x7
; 0000 00F0         if(vrem < 2) delay_ms(1000);
	RCALL SUBOPT_0x9
	CPI  R26,LOW(0x2)
	BRSH _0x2A
	LDI  R26,LOW(1000)
	LDI  R27,HIGH(1000)
	RJMP _0x14E
; 0000 00F1         else delay_ms(500);
_0x2A:
	LDI  R26,LOW(500)
	LDI  R27,HIGH(500)
_0x14E:
	RCALL _delay_ms
; 0000 00F2 }
	RET
; .FEND
;
;
;
;char vibor(void)     //    
; 0000 00F7 {
_vibor:
; .FSTART _vibor
; 0000 00F8     bol = 0;
	LDI  R30,LOW(0)
	RCALL SUBOPT_0xA
; 0000 00F9     lcd_clear();
	RCALL _lcd_clear
; 0000 00FA     vrem = 0;
	RCALL SUBOPT_0xB
; 0000 00FB     paus = 0;
	RCALL SUBOPT_0xC
; 0000 00FC     while (paus++<1000)
_0x2C:
	RCALL SUBOPT_0xD
	__CPD1N 0x3E8
	BRSH _0x2E
; 0000 00FD     {
; 0000 00FE         lcdbol();
	RCALL _lcdbol
; 0000 00FF         if(!ubr)
	SBIC 0x16,7
	RJMP _0x2F
; 0000 0100         {
; 0000 0101             vrem = 0;
	RCALL SUBOPT_0xB
; 0000 0102             delay_ms(100);
	RCALL SUBOPT_0xE
; 0000 0103             while((!ubr)&(paus++ < 100000)){#asm("wdr")};
_0x30:
	RCALL SUBOPT_0xF
	RCALL SUBOPT_0xD
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x186A0
	RCALL __LTD12U
	AND  R30,R0
	BREQ _0x32
	wdr
	RJMP _0x30
_0x32:
; 0000 0104             if (paus > 100000) break;
	RCALL SUBOPT_0x10
	__CPD2N 0x186A1
	BRSH _0x2E
; 0000 0105             else
; 0000 0106              {
; 0000 0107                 zvuk = 1 ;
	RCALL SUBOPT_0x11
; 0000 0108                 delay_ms(50);
; 0000 0109                 zvuk = 0;
; 0000 010A                 if (bol--==0) bol = 44;
	RCALL SUBOPT_0x2
	SUBI R30,LOW(1)
	RCALL SUBOPT_0xA
	SUBI R30,-LOW(1)
	BRNE _0x39
	LDI  R30,LOW(44)
	RCALL SUBOPT_0xA
; 0000 010B              };
_0x39:
; 0000 010C              paus = 0;
	RCALL SUBOPT_0xC
; 0000 010D         };
_0x2F:
; 0000 010E         if(!dob)
	SBIC 0x16,6
	RJMP _0x3A
; 0000 010F         {
; 0000 0110             paus = 0;
	RCALL SUBOPT_0xC
; 0000 0111             vrem = 0;
	RCALL SUBOPT_0xB
; 0000 0112             zvuk = 1 ;
	RCALL SUBOPT_0x11
; 0000 0113             delay_ms(50);
; 0000 0114             zvuk = 0;
; 0000 0115             if (++bol>44) bol = 0;
	LDS  R26,_bol
	SUBI R26,-LOW(1)
	STS  _bol,R26
	CPI  R26,LOW(0x2D)
	BRLO _0x3F
	LDI  R30,LOW(0)
	RCALL SUBOPT_0xA
; 0000 0116         }
_0x3F:
; 0000 0117     }
_0x3A:
	RJMP _0x2C
_0x2E:
; 0000 0118 
; 0000 0119     return bol;
	RCALL SUBOPT_0x2
	RET
; 0000 011A 
; 0000 011B }
; .FEND
;
;
;// Declare your global variables here
;
;void main(void)
; 0000 0121 {
_main:
; .FSTART _main
; 0000 0122 // Declare your local variables here
; 0000 0123 
; 0000 0124 // Port B initialization
; 0000 0125 // Func7=In Func6=In Func5=Out Func4=Out Func3=Out Func2=Out Func1=in Func0=Out
; 0000 0126 // State7=P State6=P State5=0 State4=1 State3=0 State2=0 State1=T State0=1
; 0000 0127 PORTB=0xD1;
	LDI  R30,LOW(209)
	OUT  0x18,R30
; 0000 0128 DDRB=0x3D;
	LDI  R30,LOW(61)
	OUT  0x17,R30
; 0000 0129 
; 0000 012A // Port C initialization
; 0000 012B // Func6=Out Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 012C // State6=P State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 012D PORTC=0b1111111;
	LDI  R30,LOW(127)
	OUT  0x15,R30
; 0000 012E DDRC=0x00;
	LDI  R30,LOW(0)
	OUT  0x14,R30
; 0000 012F 
; 0000 0130 // Port D initialization
; 0000 0131 // Func7=In Func6=In Func5=In Func4=In Func3=Out Func2=In Func1=In Func0=In
; 0000 0132 // State7=T State6=T State5=T State4=T State3=1 State2=T State1=T State0=T
; 0000 0133 PORTD=0x08;
	LDI  R30,LOW(8)
	OUT  0x12,R30
; 0000 0134 DDRD=0x08;
	OUT  0x11,R30
; 0000 0135 
; 0000 0136 // Timer/Counter 0 initialization
; 0000 0137 // Clock source: System Clock
; 0000 0138 // Clock value: 8000,000 kHz
; 0000 0139 TCCR0=0x01;
	LDI  R30,LOW(1)
	OUT  0x33,R30
; 0000 013A TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x32,R30
; 0000 013B 
; 0000 013C // Timer/Counter 1 initialization
; 0000 013D // Clock source: System Clock
; 0000 013E // Clock value: 8000,000 kHz
; 0000 013F // Mode: Fast PWM top=ICR1
; 0000 0140 // OC1A output: Discon.
; 0000 0141 // OC1B output: Inverted
; 0000 0142 // Noise Canceler: Off
; 0000 0143 // Input Capture on Falling Edge
; 0000 0144 // Timer 1 Overflow Interrupt: Off
; 0000 0145 // Input Capture Interrupt: Off
; 0000 0146 // Compare A Match Interrupt: Off
; 0000 0147 // Compare B Match Interrupt: Off
; 0000 0148 TCCR1A=0x00;//32;
	OUT  0x2F,R30
; 0000 0149 TCCR1B=0x19;
	LDI  R30,LOW(25)
	OUT  0x2E,R30
; 0000 014A TCNT1H=0x00;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
; 0000 014B TCNT1L=0x00;
	OUT  0x2C,R30
; 0000 014C ICR1H=0x00;
	OUT  0x27,R30
; 0000 014D ICR1L=0xA0;
	LDI  R30,LOW(160)
	OUT  0x26,R30
; 0000 014E OCR1AH=0x00;
	LDI  R30,LOW(0)
	OUT  0x2B,R30
; 0000 014F OCR1AL=0x00;
	OUT  0x2A,R30
; 0000 0150 OCR1BH=0x00;
	OUT  0x29,R30
; 0000 0151 OCR1BL=0x18;
	LDI  R30,LOW(24)
	OUT  0x28,R30
; 0000 0152 
; 0000 0153 // Timer/Counter 2 initialization
; 0000 0154 // Clock source: System Clock
; 0000 0155 // Clock value: Timer 2 Stopped
; 0000 0156 // Mode: Normal top=FFh
; 0000 0157 // OC2 output: Disconnected
; 0000 0158 ASSR=0x00;
	LDI  R30,LOW(0)
	OUT  0x22,R30
; 0000 0159 TCCR2=0x00;
	OUT  0x25,R30
; 0000 015A TCNT2=0x00;
	OUT  0x24,R30
; 0000 015B OCR2=0x00;
	OUT  0x23,R30
; 0000 015C 
; 0000 015D // External Interrupt(s) initialization
; 0000 015E // INT0: Off
; 0000 015F // INT1: Off
; 0000 0160 MCUCR=0x00;
	OUT  0x35,R30
; 0000 0161 
; 0000 0162 // Timer(s)/Counter(s) Interrupt(s) initialization
; 0000 0163 TIMSK=0x00;
	OUT  0x39,R30
; 0000 0164 
; 0000 0165 
; 0000 0166 // Watchdog Timer initialization
; 0000 0167 // Watchdog Timer Prescaler: OSC/2048k
; 0000 0168 #pragma optsize-
; 0000 0169 WDTCR=0x1F;
	LDI  R30,LOW(31)
	OUT  0x21,R30
; 0000 016A WDTCR=0x0F;
	LDI  R30,LOW(15)
	OUT  0x21,R30
; 0000 016B #ifdef _OPTIMIZE_SIZE_
; 0000 016C #pragma optsize+
; 0000 016D #endif
; 0000 016E 
; 0000 016F // Analog Comparator initialization
; 0000 0170 // Analog Comparator: Off
; 0000 0171 // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 0172 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
; 0000 0173 SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
; 0000 0174 
; 0000 0175 // ADC initialization
; 0000 0176 // ADC Clock frequency: 1000,000 kHz
; 0000 0177 // ADC Voltage Reference: Int., cap. on AREF
; 0000 0178 ADMUX=ADC_VREF_TYPE & 0xff;
	LDI  R30,LOW(192)
	OUT  0x7,R30
; 0000 0179 ADCSRA=0x83;
	LDI  R30,LOW(131)
	OUT  0x6,R30
; 0000 017A 
; 0000 017B // LCD module initialization
; 0000 017C lcd_init(8);
	LDI  R26,LOW(8)
	RCALL _lcd_init
; 0000 017D 
; 0000 017E 
; 0000 017F vihod = 1;                         //  2/3 
	SBI  0x18,4
; 0000 0180 napr = 1;                           //    
	SBI  0x18,0
; 0000 0181 d = 500;
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	MOVW R6,R30
; 0000 0182 n = 290;
	LDI  R30,LOW(290)
	LDI  R31,HIGH(290)
	MOVW R8,R30
; 0000 0183 tok = 24;                            //  
	LDI  R30,LOW(24)
	LDI  R31,HIGH(24)
	MOVW R12,R30
; 0000 0184 
; 0000 0185 
; 0000 0186 
; 0000 0187 // Global enable interrupts
; 0000 0188 #asm("sei")
	sei
; 0000 0189 
; 0000 018A zvuk = 1;
	SBI  0x17,1
; 0000 018B delay_ms(200);
	LDI  R26,LOW(200)
	RCALL SUBOPT_0x12
; 0000 018C d = read_adc(0);         //  
	LDI  R26,LOW(0)
	RCALL _read_adc
	MOVW R6,R30
; 0000 018D     for(vrem=6;vrem>0;vrem=vrem-1)
	LDI  R30,LOW(6)
	RCALL SUBOPT_0x7
_0x47:
	RCALL SUBOPT_0x9
	CPI  R26,LOW(0x1)
	BRLO _0x48
; 0000 018E     {
; 0000 018F     time = read_adc(0);
	LDI  R26,LOW(0)
	RCALL _read_adc
	STS  _time,R30
	STS  _time+1,R31
; 0000 0190     if (d>time) d=time;
	CP   R30,R6
	CPC  R31,R7
	BRSH _0x49
	__GETWRMN 6,7,0,_time
; 0000 0191     };
_0x49:
	RCALL SUBOPT_0x8
	SUBI R30,LOW(1)
	RCALL SUBOPT_0x7
	RJMP _0x47
_0x48:
; 0000 0192  time = 0;
	RCALL SUBOPT_0x13
; 0000 0193  zvuk = 0;
	CBI  0x17,1
; 0000 0194 
; 0000 0195 
; 0000 0196  vrem0 = (float)d*(    0.435   /40);                      //    .   + 0.1
	RCALL SUBOPT_0x14
	__GETD2N 0x3C322D0E
	RCALL __MULF12
	RCALL SUBOPT_0x15
; 0000 0197  ftoa(vrem0,2,tok0);
	LDI  R30,LOW(2)
	RCALL SUBOPT_0x16
; 0000 0198  lcd_clear();
	RCALL _lcd_clear
; 0000 0199     if(vrem0 < 4.8)
	LDS  R26,_vrem0
	LDS  R27,_vrem0+1
	LDS  R24,_vrem0+2
	LDS  R25,_vrem0+3
	__GETD1N 0x4099999A
	RCALL __CMPF12
	BRSH _0x4C
; 0000 019A     {
; 0000 019B     lcd_putsf("Low batt");
	__POINTW2FN _0x0,9
	RCALL _lcd_putsf
; 0000 019C         for(d=9;d>0;d=d-1)
	LDI  R30,LOW(9)
	LDI  R31,HIGH(9)
	MOVW R6,R30
_0x4E:
	CLR  R0
	CP   R0,R6
	CPC  R0,R7
	BRSH _0x4F
; 0000 019D         {
; 0000 019E         delay_ms(100);
	RCALL SUBOPT_0xE
; 0000 019F         zvuk = 1;
	RCALL SUBOPT_0x11
; 0000 01A0         delay_ms(50);
; 0000 01A1         zvuk = 0;
; 0000 01A2         };
	MOVW R30,R6
	SBIW R30,1
	MOVW R6,R30
	RJMP _0x4E
_0x4F:
; 0000 01A3     } else lcd_putsf("Battery ");
	RJMP _0x54
_0x4C:
	__POINTW2FN _0x0,18
	RCALL _lcd_putsf
; 0000 01A4 lcd_putsf("U=");
_0x54:
	__POINTW2FN _0x0,27
	RCALL _lcd_putsf
; 0000 01A5 lcd_puts(tok0);
	LDI  R26,LOW(_tok0)
	LDI  R27,HIGH(_tok0)
	RCALL _lcd_puts
; 0000 01A6 lcd_putsf(" v");
	__POINTW2FN _0x0,30
	RCALL _lcd_putsf
; 0000 01A7     while(paus<200000)
_0x55:
	RCALL SUBOPT_0x10
	__CPD2N 0x30D40
	BRSH _0x57
; 0000 01A8     {
; 0000 01A9     #asm("wdr")
	wdr
; 0000 01AA     paus=paus+1;
	RCALL SUBOPT_0x17
; 0000 01AB         if(!ubr)
	SBIC 0x16,7
	RJMP _0x58
; 0000 01AC         {
; 0000 01AD         PORTB.7 = 0;
	CBI  0x18,7
; 0000 01AE         DDRB.7 = 1;
	SBI  0x17,7
; 0000 01AF         };
_0x58:
; 0000 01B0     };
	RJMP _0x55
_0x57:
; 0000 01B1 paus=0;
	RCALL SUBOPT_0xC
; 0000 01B2 lcd_gotoxy(0,1);
	RCALL SUBOPT_0x1
	LDI  R26,LOW(1)
	RCALL _lcd_gotoxy
; 0000 01B3  if (!ubr)
	SBIC 0x16,7
	RJMP _0x5D
; 0000 01B4   {
; 0000 01B5   DDRB.7 = 0;
	CBI  0x17,7
; 0000 01B6   PORTB.7 = 1;
	SBI  0x18,7
; 0000 01B7   lcd_putsf("BAPIAHT2 ");
	__POINTW2FN _0x0,33
	RCALL _lcd_putsf
; 0000 01B8     zvuk = 1 ;
	RCALL SUBOPT_0x11
; 0000 01B9     delay_ms(50);
; 0000 01BA     zvuk = 0;
; 0000 01BB     delay_ms(50);
	RCALL SUBOPT_0x18
; 0000 01BC     zvuk = 1 ;
	RCALL SUBOPT_0x11
; 0000 01BD     delay_ms(50);
; 0000 01BE     zvuk = 0;
; 0000 01BF     delay_ms(300);
	LDI  R26,LOW(300)
	LDI  R27,HIGH(300)
	RCALL _delay_ms
; 0000 01C0 //=========================================
; 0000 01C1 //  2- 
; 0000 01C2 //=========================================
; 0000 01C3         if (!dob)
	SBIC 0x16,6
	RJMP _0x6A
; 0000 01C4         {
; 0000 01C5         zvuk = 1 ;
	RCALL SUBOPT_0x11
; 0000 01C6         delay_ms(50);
; 0000 01C7         zvuk = 0;
; 0000 01C8         delay_ms(400);
	RCALL SUBOPT_0x19
; 0000 01C9         lcd_clear();
	RCALL _lcd_clear
; 0000 01CA         lcd_putsf("3AHOBO 2-HET,+DA");
	__POINTW2FN _0x0,43
	RCALL _lcd_putsf
; 0000 01CB         while(!dob) #asm("wdr");
_0x6F:
	SBIC 0x16,6
	RJMP _0x71
	wdr
; 0000 01CC         while (ubr&&dob&&(paus<1000000)) {#asm("wdr") paus = paus+1;};
	RJMP _0x6F
_0x71:
_0x72:
	SBIS 0x16,7
	RJMP _0x75
	SBIS 0x16,6
	RJMP _0x75
	RCALL SUBOPT_0x1A
	BRLO _0x76
_0x75:
	RJMP _0x74
_0x76:
	wdr
	RCALL SUBOPT_0x17
	RJMP _0x72
_0x74:
; 0000 01CD             if(!dob)
	SBIC 0x16,6
	RJMP _0x77
; 0000 01CE             {
; 0000 01CF //        2
; 0000 01D0             bol2 = vibor();
	RCALL _vibor
	LDI  R26,LOW(_bol2)
	LDI  R27,HIGH(_bol2)
	RCALL __EEPROMWRB
; 0000 01D1             zvuk = 1 ;
	RCALL SUBOPT_0x11
; 0000 01D2             delay_ms(50);
; 0000 01D3             zvuk = 0;
; 0000 01D4             delay_ms(400);
	RCALL SUBOPT_0x19
; 0000 01D5             seans2 = 0;
	RCALL SUBOPT_0x1B
	LDI  R30,LOW(0)
	RCALL __EEPROMWRB
; 0000 01D6             };
_0x77:
; 0000 01D7 
; 0000 01D8         };
_0x6A:
; 0000 01D9 //=====================================
; 0000 01DA //      2- 
; 0000 01DB //=====================================
; 0000 01DC 
; 0000 01DD   seans = seans2;
	RCALL SUBOPT_0x1B
	RCALL __EEPROMRDB
	STS  _seans,R30
; 0000 01DE   bol = bol2;
	LDI  R26,LOW(_bol2)
	LDI  R27,HIGH(_bol2)
	RCALL __EEPROMRDB
	RCALL SUBOPT_0xA
; 0000 01DF //  rezh0 = rezhimi[bol][seans] ;
; 0000 01E0 //  rezh0 = rezh2[seans] ;
; 0000 01E1   chel = 1;
	SET
	BLD  R2,6
; 0000 01E2   }
; 0000 01E3   else
	RJMP _0x7C
_0x5D:
; 0000 01E4   {
; 0000 01E5 
; 0000 01E6       if (!dob)
	SBIC 0x16,6
	RJMP _0x7D
; 0000 01E7      {
; 0000 01E8         zvuk = 1 ;
	RCALL SUBOPT_0x11
; 0000 01E9         delay_ms(50);
; 0000 01EA         zvuk = 0;
; 0000 01EB         delay_ms(400);
	RCALL SUBOPT_0x19
; 0000 01EC      lcd_clear();
	RCALL _lcd_clear
; 0000 01ED      lcd_putsf("3AHOBO 1-HET,+DA");
	__POINTW2FN _0x0,60
	RCALL _lcd_putsf
; 0000 01EE      while(!dob) #asm("wdr");
_0x82:
	SBIC 0x16,6
	RJMP _0x84
	wdr
; 0000 01EF      while (ubr&&dob&&(paus<1000000)) {#asm("wdr") paus = paus+1;};
	RJMP _0x82
_0x84:
_0x85:
	SBIS 0x16,7
	RJMP _0x88
	SBIS 0x16,6
	RJMP _0x88
	RCALL SUBOPT_0x1A
	BRLO _0x89
_0x88:
	RJMP _0x87
_0x89:
	wdr
	RCALL SUBOPT_0x17
	RJMP _0x85
_0x87:
; 0000 01F0         if(!dob)
	SBIC 0x16,6
	RJMP _0x8A
; 0000 01F1         {
; 0000 01F2 //        1
; 0000 01F3         bol1 = vibor();
	RCALL _vibor
	LDI  R26,LOW(_bol1)
	LDI  R27,HIGH(_bol1)
	RCALL __EEPROMWRB
; 0000 01F4         zvuk = 1 ;
	RCALL SUBOPT_0x11
; 0000 01F5         delay_ms(50);
; 0000 01F6         zvuk = 0;
; 0000 01F7         delay_ms(400);
	RCALL SUBOPT_0x19
; 0000 01F8         seans1 = 0;
	RCALL SUBOPT_0x1C
	LDI  R30,LOW(0)
	RCALL __EEPROMWRB
; 0000 01F9         rezh0 = rezhimi[bol][0];
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x1E
; 0000 01FA 
; 0000 01FB         };
_0x8A:
; 0000 01FC 
; 0000 01FD      };
_0x7D:
; 0000 01FE 
; 0000 01FF   seans=seans1;
	RCALL SUBOPT_0x1C
	RCALL __EEPROMRDB
	STS  _seans,R30
; 0000 0200   bol = bol1;
	LDI  R26,LOW(_bol1)
	LDI  R27,HIGH(_bol1)
	RCALL __EEPROMRDB
	RCALL SUBOPT_0xA
; 0000 0201 //  rezh0 = rezhimi[bol][seans];
; 0000 0202 
; 0000 0203 //  rezh0 = rezh1[seans];
; 0000 0204   };
_0x7C:
; 0000 0205 
; 0000 0206 
; 0000 0207 
; 0000 0208     if (seans == 0)
	RCALL SUBOPT_0x1F
	CPI  R30,0
	BRNE _0x8F
; 0000 0209     {
; 0000 020A     n=0;
	CLR  R8
	CLR  R9
; 0000 020B     lcd_clear();
	RCALL _lcd_clear
; 0000 020C     lcd_putsf("  Kypc   3AHOBO!" );
	__POINTW2FN _0x0,77
	RCALL _lcd_putsf
; 0000 020D         while(n++<20)
_0x90:
	RCALL SUBOPT_0x20
	MOVW R8,R30
	SBIW R30,21
	BRSH _0x92
; 0000 020E         {
; 0000 020F         delay_ms(50);                      //  20 
	RCALL SUBOPT_0x18
; 0000 0210         zvuk = 1;
	RCALL SUBOPT_0x11
; 0000 0211         delay_ms(50);
; 0000 0212         zvuk = 0;
; 0000 0213         }
	RJMP _0x90
_0x92:
; 0000 0214     n=290;
	LDI  R30,LOW(290)
	LDI  R31,HIGH(290)
	MOVW R8,R30
; 0000 0215     }
; 0000 0216 
; 0000 0217 lcd_clear();
_0x8F:
	RCALL _lcd_clear
; 0000 0218 lcd_putsf("BAPIAHT");
	__POINTW2FN _0x0,94
	RCALL _lcd_putsf
; 0000 0219 lcd_putchar(chel+0x31);
	LDI  R30,0
	SBRC R2,6
	LDI  R30,1
	SUBI R30,-LOW(49)
	MOV  R26,R30
	RCALL _lcd_putchar
; 0000 021A lcd_putsf("CEAHC= ");
	__POINTW2FN _0x0,102
	RCALL _lcd_putsf
; 0000 021B lcd_putchar(seans+0x30);
	RCALL SUBOPT_0x21
	SUBI R26,-LOW(48)
	RCALL _lcd_putchar
; 0000 021C delay_ms(2000);
	LDI  R26,LOW(2000)
	LDI  R27,HIGH(2000)
	RCALL _delay_ms
; 0000 021D lcd_clear();
	RCALL _lcd_clear
; 0000 021E paus = 0;
	RCALL SUBOPT_0xC
; 0000 021F vrem = 0;
	RCALL SUBOPT_0xB
; 0000 0220 rezh0 = rezhimi[bol][seans] ;
	RCALL SUBOPT_0x1D
	MOVW R26,R30
	RCALL SUBOPT_0x1F
	LDI  R31,0
	RCALL SUBOPT_0x6
	RCALL SUBOPT_0x1E
; 0000 0221 while (paus++<12) lcdbol();
_0x97:
	RCALL SUBOPT_0xD
	__CPD1N 0xC
	BRSH _0x99
	RCALL _lcdbol
	RJMP _0x97
_0x99:
; 0000 0224 #asm("wdr")
	wdr
; 0000 0225 PORTC = 0b1000000;
	LDI  R30,LOW(64)
	OUT  0x15,R30
; 0000 0226 zvuk = 1;
	RCALL SUBOPT_0x11
; 0000 0227 delay_ms(50);
; 0000 0228 zvuk = 0;
; 0000 0229             if (rezh0==3)
	RCALL SUBOPT_0x22
	CPI  R26,LOW(0x3)
	BRNE _0x9E
; 0000 022A             {
; 0000 022B             kond=1;              //   (. )
	RCALL SUBOPT_0x23
; 0000 022C             k1=1;                         //  
; 0000 022D             k = 0;
; 0000 022E             } else
	RJMP _0xA1
_0x9E:
; 0000 022F             {
; 0000 0230             if (rezh0 == 2) k=1; else k = 0;        //  
	RCALL SUBOPT_0x22
	CPI  R26,LOW(0x2)
	BRNE _0xA2
	SET
	RJMP _0x14F
_0xA2:
	CLT
_0x14F:
	BLD  R2,1
; 0000 0231             k1=0;
	RCALL SUBOPT_0x24
; 0000 0232             kond=0;              //   (.)
; 0000 0233             };
_0xA1:
; 0000 0234         lcd_clear();
	RCALL SUBOPT_0x25
; 0000 0235         lcd_putsf(" Pe - ");
; 0000 0236         if (k) lcd_putsf("2 Mogy-10k");
	SBRC R2,1
	RCALL SUBOPT_0x26
; 0000 0237         if(k1) lcd_putsf("3 Tpey-HeM");
	SBRC R2,4
	RCALL SUBOPT_0x27
; 0000 0238         if((!k1)&&(!k)) lcd_putsf("1 POBH-HeM");
	SBRC R2,4
	RJMP _0xA9
	SBRS R2,1
	RJMP _0xAA
_0xA9:
	RJMP _0xA8
_0xAA:
	RCALL SUBOPT_0x28
; 0000 0239         zvuk = 1;              //   ,   .
_0xA8:
	RCALL SUBOPT_0x11
; 0000 023A         delay_ms(50);
; 0000 023B         zvuk = 0;
; 0000 023C         delay_ms(100);
	RCALL SUBOPT_0xE
; 0000 023D         zvuk = k|k1;
	RCALL SUBOPT_0x29
	BRNE _0xAF
	CBI  0x17,1
	RJMP _0xB0
_0xAF:
	SBI  0x17,1
_0xB0:
; 0000 023E         delay_ms(50);
	RCALL SUBOPT_0x18
; 0000 023F         zvuk = 0;
	RCALL SUBOPT_0x2A
; 0000 0240         delay_ms(100);
; 0000 0241         zvuk = k1;
	SBRC R2,4
	RJMP _0xB3
	CBI  0x17,1
	RJMP _0xB4
_0xB3:
	SBI  0x17,1
_0xB4:
; 0000 0242         delay_ms(50);
	RCALL SUBOPT_0x18
; 0000 0243         zvuk = 0;
	CBI  0x17,1
; 0000 0244 
; 0000 0245 
; 0000 0246 while (1)
_0xB7:
; 0000 0247 {
; 0000 0248 #asm("wdr")
	wdr
; 0000 0249       // Place your code here
; 0000 024A     if ((!dob)&(tok<300))        //     
	LDI  R30,0
	SBIS 0x16,6
	LDI  R30,1
	MOV  R0,R30
	MOVW R26,R12
	LDI  R30,LOW(300)
	LDI  R31,HIGH(300)
	RCALL __LTW12U
	AND  R30,R0
	BREQ _0xBA
; 0000 024B     {
; 0000 024C         if (l) tok = tok + 4;       //  ,  
	SBRS R2,2
	RJMP _0xBB
	MOVW R30,R12
	ADIW R30,4
	MOVW R12,R30
; 0000 024D         else
	RJMP _0xBC
_0xBB:
; 0000 024E         {
; 0000 024F         while(!dob);
_0xBD:
	SBIS 0x16,6
	RJMP _0xBD
; 0000 0250         time = 0;
	RCALL SUBOPT_0x13
; 0000 0251         if(++rezh0 > 3) rezh0 = 1;
	RCALL SUBOPT_0x22
	SUBI R26,-LOW(1)
	STS  _rezh0,R26
	CPI  R26,LOW(0x4)
	BRLO _0xC0
	LDI  R30,LOW(1)
	STS  _rezh0,R30
; 0000 0252             if (rezh0==3)
_0xC0:
	RCALL SUBOPT_0x22
	CPI  R26,LOW(0x3)
	BRNE _0xC1
; 0000 0253             {
; 0000 0254             kond=1;              //   (. )
	RCALL SUBOPT_0x23
; 0000 0255             k1=1;                         //  
; 0000 0256             k = 0;
; 0000 0257             } else
	RJMP _0xC4
_0xC1:
; 0000 0258             {
; 0000 0259             if (rezh0 == 2) k=1;  else k = 0;       //  
	RCALL SUBOPT_0x22
	CPI  R26,LOW(0x2)
	BRNE _0xC5
	SET
	RJMP _0x150
_0xC5:
	CLT
_0x150:
	BLD  R2,1
; 0000 025A             k1=0;
	RCALL SUBOPT_0x24
; 0000 025B             kond=0;              //   (.)
; 0000 025C             };
_0xC4:
; 0000 025D         lcd_clear();
	RCALL SUBOPT_0x25
; 0000 025E         lcd_putsf(" Pe - ");
; 0000 025F         if (k) lcd_putsf("2 Mogy-10k");
	SBRC R2,1
	RCALL SUBOPT_0x26
; 0000 0260         if(k1) lcd_putsf("3 Tpey-HeM");
	SBRC R2,4
	RCALL SUBOPT_0x27
; 0000 0261         if((!k1)&&(!k)) lcd_putsf("1 POBH-HeM");
	SBRC R2,4
	RJMP _0xCC
	SBRS R2,1
	RJMP _0xCD
_0xCC:
	RJMP _0xCB
_0xCD:
	RCALL SUBOPT_0x28
; 0000 0262         zvuk = 1;              //   ,   .
_0xCB:
	RCALL SUBOPT_0x11
; 0000 0263         delay_ms(50);
; 0000 0264         zvuk = 0;
; 0000 0265         delay_ms(100);
	RCALL SUBOPT_0xE
; 0000 0266         zvuk = k|k1;
	RCALL SUBOPT_0x29
	BRNE _0xD2
	CBI  0x17,1
	RJMP _0xD3
_0xD2:
	SBI  0x17,1
_0xD3:
; 0000 0267         delay_ms(50);
	RCALL SUBOPT_0x18
; 0000 0268         zvuk = 0;
	RCALL SUBOPT_0x2A
; 0000 0269         delay_ms(100);
; 0000 026A         zvuk = k1;
	SBRC R2,4
	RJMP _0xD6
	CBI  0x17,1
	RJMP _0xD7
_0xD6:
	SBI  0x17,1
_0xD7:
; 0000 026B         delay_ms(50);
	RCALL SUBOPT_0x18
; 0000 026C         zvuk = 0;
	CBI  0x17,1
; 0000 026D         };
_0xBC:
; 0000 026E     };
_0xBA:
; 0000 026F     if ((!ubr)&(tok>4))        //    "-":
	RCALL SUBOPT_0xF
	MOVW R26,R12
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	RCALL __GTW12U
	AND  R30,R0
	BREQ _0xDA
; 0000 0270     {
; 0000 0271         if (l) tok = tok - 4;      //     
	SBRS R2,2
	RJMP _0xDB
	MOVW R30,R12
	SBIW R30,4
	MOVW R12,R30
; 0000 0272         else
	RJMP _0xDC
_0xDB:
; 0000 0273         {
; 0000 0274         while(!ubr);
_0xDD:
	SBIS 0x16,7
	RJMP _0xDD
; 0000 0275         zvuk = 1;              //   ,   .
	RCALL SUBOPT_0x11
; 0000 0276         delay_ms(50);
; 0000 0277         zvuk = 0;
; 0000 0278         delay_ms(100);
	RCALL SUBOPT_0xE
; 0000 0279         zvuk = k|k1;
	RCALL SUBOPT_0x29
	BRNE _0xE4
	CBI  0x17,1
	RJMP _0xE5
_0xE4:
	SBI  0x17,1
_0xE5:
; 0000 027A         delay_ms(50);
	RCALL SUBOPT_0x18
; 0000 027B         zvuk = 0;
	RCALL SUBOPT_0x2A
; 0000 027C         delay_ms(100);
; 0000 027D         zvuk = k1;
	SBRC R2,4
	RJMP _0xE8
	CBI  0x17,1
	RJMP _0xE9
_0xE8:
	SBI  0x17,1
_0xE9:
; 0000 027E         delay_ms(50);
	RCALL SUBOPT_0x18
; 0000 027F         zvuk = 0;
	CBI  0x17,1
; 0000 0280         l = 1;                        //  .
	SET
	BLD  R2,2
; 0000 0281         time = 0;
	RCALL SUBOPT_0x13
; 0000 0282         TIMSK=0x01;
	LDI  R30,LOW(1)
	OUT  0x39,R30
; 0000 0283         };
_0xDC:
; 0000 0284     };
_0xDA:
; 0000 0285     if(l)                         //  :
	SBRS R2,2
	RJMP _0xEC
; 0000 0286     {
; 0000 0287     zvuk = 0;
	CBI  0x17,1
; 0000 0288     delay_ms(300);               //     
	LDI  R26,LOW(300)
	LDI  R27,HIGH(300)
	RCALL _delay_ms
; 0000 0289      if (n>288) j = 1;                    //    
	LDI  R30,LOW(288)
	LDI  R31,HIGH(288)
	CP   R30,R8
	CPC  R31,R9
	BRSH _0xEF
	SET
	BLD  R2,0
; 0000 028A      if (n<220) j = 0;
_0xEF:
	LDI  R30,LOW(220)
	LDI  R31,HIGH(220)
	CP   R8,R30
	CPC  R9,R31
	BRSH _0xF0
	CLT
	BLD  R2,0
; 0000 028B      if (j) n--; else n++;                //     (  )
_0xF0:
	SBRS R2,0
	RJMP _0xF1
	MOVW R30,R8
	SBIW R30,1
	RJMP _0x151
_0xF1:
	RCALL SUBOPT_0x20
_0x151:
	MOVW R8,R30
; 0000 028C         if (time == 1800)                            //   2 
	RCALL SUBOPT_0x2B
	CPI  R26,LOW(0x708)
	LDI  R30,HIGH(0x708)
	CPC  R27,R30
	BREQ PC+2
	RJMP _0xF3
; 0000 028D         {
; 0000 028E         time0 = tok;
	__PUTWMRN _time0,0,12,13
; 0000 028F         tok = 0;
	CLR  R12
	CLR  R13
; 0000 0290         delay_ms(1000);
	LDI  R26,LOW(1000)
	LDI  R27,HIGH(1000)
	RCALL _delay_ms
; 0000 0291         vrem = rezh0;
	LDS  R30,_rezh0
	RCALL SUBOPT_0x7
; 0000 0292         rezh0 = rezhimi[bol][seans+10];
	RCALL SUBOPT_0x1D
	MOVW R26,R30
	RCALL SUBOPT_0x1F
	LDI  R31,0
	ADIW R30,10
	RCALL SUBOPT_0x6
	RCALL SUBOPT_0x1E
; 0000 0293             if (rezh0==3)
	RCALL SUBOPT_0x22
	CPI  R26,LOW(0x3)
	BRNE _0xF4
; 0000 0294             {
; 0000 0295             if (vrem == 2) time0=time0*3/4;
	RCALL SUBOPT_0x9
	CPI  R26,LOW(0x2)
	BRNE _0xF5
	RCALL SUBOPT_0x2C
	LDI  R30,LOW(3)
	RCALL __MULB1W2U
	RCALL __LSRW2
	RCALL SUBOPT_0x2D
; 0000 0296             if (vrem == 1) time0=time0*6/5 ;
_0xF5:
	RCALL SUBOPT_0x9
	CPI  R26,LOW(0x1)
	BRNE _0xF6
	RCALL SUBOPT_0x2C
	LDI  R30,LOW(6)
	RCALL SUBOPT_0x2E
	RCALL SUBOPT_0x2F
; 0000 0297             kond=1;              //   (. )
_0xF6:
	RCALL SUBOPT_0x23
; 0000 0298             k1=1;                         //  
; 0000 0299             k = 0;
; 0000 029A             } else
	RJMP _0xF9
_0xF4:
; 0000 029B             {
; 0000 029C 
; 0000 029D                 if (rezh0 == 2)
	RCALL SUBOPT_0x22
	CPI  R26,LOW(0x2)
	BRNE _0xFA
; 0000 029E                 {
; 0000 029F                 if (vrem == 3) time0=time0*4/3;
	RCALL SUBOPT_0x9
	CPI  R26,LOW(0x3)
	BRNE _0xFB
	RCALL SUBOPT_0x2C
	LDI  R30,LOW(4)
	RCALL SUBOPT_0x2E
	RCALL SUBOPT_0x30
; 0000 02A0                 if (vrem == 1) time0 = time0*5/3;
_0xFB:
	RCALL SUBOPT_0x9
	CPI  R26,LOW(0x1)
	BRNE _0xFC
	RCALL SUBOPT_0x2C
	LDI  R30,LOW(5)
	RCALL SUBOPT_0x2E
	RCALL SUBOPT_0x30
; 0000 02A1                 k=1;
_0xFC:
	SET
	RJMP _0x152
; 0000 02A2                 }  else
_0xFA:
; 0000 02A3                 {
; 0000 02A4                 if (vrem == 3) time0=time0*5/6;
	RCALL SUBOPT_0x9
	CPI  R26,LOW(0x3)
	BRNE _0xFE
	RCALL SUBOPT_0x2C
	LDI  R30,LOW(5)
	RCALL SUBOPT_0x2E
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	RCALL __DIVW21U
	RCALL SUBOPT_0x2D
; 0000 02A5                 if (vrem == 2) time0 = time0*3/5;
_0xFE:
	RCALL SUBOPT_0x9
	CPI  R26,LOW(0x2)
	BRNE _0xFF
	RCALL SUBOPT_0x2C
	LDI  R30,LOW(3)
	RCALL SUBOPT_0x2E
	RCALL SUBOPT_0x2F
; 0000 02A6                 k = 0;      //  
_0xFF:
	CLT
_0x152:
	BLD  R2,1
; 0000 02A7                 };
; 0000 02A8             k1=0;
	RCALL SUBOPT_0x24
; 0000 02A9             kond=0;              //   (.)
; 0000 02AA             };
_0xF9:
; 0000 02AB         lcd_clear();
	RCALL SUBOPT_0x25
; 0000 02AC         lcd_putsf(" Pe - ");
; 0000 02AD         if (k) lcd_putsf("2 Mogy-10k");
	SBRC R2,1
	RCALL SUBOPT_0x26
; 0000 02AE         if(k1) lcd_putsf("3 Tpey-HeM");
	SBRC R2,4
	RCALL SUBOPT_0x27
; 0000 02AF         if((!k1)&&(!k)) lcd_putsf("1 POBH-HeM");
	SBRC R2,4
	RJMP _0x105
	SBRS R2,1
	RJMP _0x106
_0x105:
	RJMP _0x104
_0x106:
	RCALL SUBOPT_0x28
; 0000 02B0         zvuk = 1;              //   ,   .
_0x104:
	RCALL SUBOPT_0x11
; 0000 02B1         delay_ms(50);
; 0000 02B2         zvuk = 0;
; 0000 02B3         delay_ms(100);
	RCALL SUBOPT_0xE
; 0000 02B4         zvuk = k|k1;
	RCALL SUBOPT_0x29
	BRNE _0x10B
	CBI  0x17,1
	RJMP _0x10C
_0x10B:
	SBI  0x17,1
_0x10C:
; 0000 02B5         delay_ms(50);
	RCALL SUBOPT_0x18
; 0000 02B6         zvuk = 0;
	RCALL SUBOPT_0x2A
; 0000 02B7         delay_ms(100);
; 0000 02B8         zvuk = k1;
	SBRC R2,4
	RJMP _0x10F
	CBI  0x17,1
	RJMP _0x110
_0x10F:
	SBI  0x17,1
_0x110:
; 0000 02B9         delay_ms(50);
	RCALL SUBOPT_0x18
; 0000 02BA         zvuk = 0;
	RCALL SUBOPT_0x2A
; 0000 02BB         delay_ms(100);
; 0000 02BC         zvuk = 1;
	SBI  0x17,1
; 0000 02BD         delay_ms(1500);
	LDI  R26,LOW(1500)
	LDI  R27,HIGH(1500)
	RCALL _delay_ms
; 0000 02BE         zvuk = 0;
	CBI  0x17,1
; 0000 02BF         tok = time0;
	__GETWRMN 12,13,0,_time0
; 0000 02C0         };
_0xF3:
; 0000 02C1         if (++time >= 3600)                        //     30 :
	RCALL SUBOPT_0x31
	CPI  R30,LOW(0xE10)
	LDI  R26,HIGH(0xE10)
	CPC  R31,R26
	BRSH PC+2
	RJMP _0x117
; 0000 02C2         {
; 0000 02C3         zvuk = !zvuk;                          //   
	SBIS 0x17,1
	RJMP _0x118
	CBI  0x17,1
	RJMP _0x119
_0x118:
	SBI  0x17,1
_0x119:
; 0000 02C4          if (time == 3600)
	RCALL SUBOPT_0x2B
	CPI  R26,LOW(0xE10)
	LDI  R30,HIGH(0xE10)
	CPC  R27,R30
	BRNE _0x11A
; 0000 02C5          {
; 0000 02C6          PORTB.7=0;                         //   "-"
	CBI  0x18,7
; 0000 02C7          DDRB.7=1;              //
	SBI  0x17,7
; 0000 02C8          zvuk = 1;                         //   
	SBI  0x17,1
; 0000 02C9          };
_0x11A:
; 0000 02CA          if (time > 3650)           //  25 :
	RCALL SUBOPT_0x2B
	CPI  R26,LOW(0xE43)
	LDI  R30,HIGH(0xE43)
	CPC  R27,R30
	BRSH PC+2
	RJMP _0x121
; 0000 02CB          {
; 0000 02CC             TIMSK=0x00;                            //  
	LDI  R30,LOW(0)
	OUT  0x39,R30
; 0000 02CD             napr = 1;
	RCALL SUBOPT_0x0
; 0000 02CE             TCCR1A=0x00;//32;
; 0000 02CF             n =0 ;
	CLR  R8
	CLR  R9
; 0000 02D0             if (seans == 9)
	RCALL SUBOPT_0x21
	CPI  R26,LOW(0x9)
	BRNE _0x124
; 0000 02D1             {
; 0000 02D2                 while(n++<20)
_0x125:
	RCALL SUBOPT_0x20
	MOVW R8,R30
	SBIW R30,21
	BRSH _0x127
; 0000 02D3                 {
; 0000 02D4                 delay_ms(50);                      //  5 
	RCALL SUBOPT_0x18
; 0000 02D5                 zvuk = 1;
	RCALL SUBOPT_0x11
; 0000 02D6                 delay_ms(50);
; 0000 02D7                 zvuk = 0;
; 0000 02D8                 }
	RJMP _0x125
_0x127:
; 0000 02D9             n=0;
	CLR  R8
	CLR  R9
; 0000 02DA             };
_0x124:
; 0000 02DB             if(time<3700)
	RCALL SUBOPT_0x2B
	CPI  R26,LOW(0xE74)
	LDI  R30,HIGH(0xE74)
	CPC  R27,R30
	BRSH _0x12C
; 0000 02DC             {
; 0000 02DD                 if (chel)
	SBRS R2,6
	RJMP _0x12D
; 0000 02DE                 {
; 0000 02DF                 if (seans < 9) seans2 = seans + 1; else seans2 = 0;
	RCALL SUBOPT_0x21
	CPI  R26,LOW(0x9)
	BRSH _0x12E
	RCALL SUBOPT_0x1F
	SUBI R30,-LOW(1)
	RCALL SUBOPT_0x1B
	RJMP _0x153
_0x12E:
	RCALL SUBOPT_0x1B
	LDI  R30,LOW(0)
_0x153:
	RCALL __EEPROMWRB
; 0000 02E0                 }
; 0000 02E1                 else
	RJMP _0x130
_0x12D:
; 0000 02E2                 {
; 0000 02E3                 if (seans < 9) seans1 = seans+1; else seans1 = 0;
	RCALL SUBOPT_0x21
	CPI  R26,LOW(0x9)
	BRSH _0x131
	RCALL SUBOPT_0x1F
	SUBI R30,-LOW(1)
	RCALL SUBOPT_0x1C
	RJMP _0x154
_0x131:
	RCALL SUBOPT_0x1C
	LDI  R30,LOW(0)
_0x154:
	RCALL __EEPROMWRB
; 0000 02E4                 };
_0x130:
; 0000 02E5             };
_0x12C:
; 0000 02E6             while(n++<5)
_0x133:
	RCALL SUBOPT_0x20
	MOVW R8,R30
	SBIW R30,6
	BRSH _0x135
; 0000 02E7             {
; 0000 02E8             delay_ms(100);                      //  5 
	RCALL SUBOPT_0xE
; 0000 02E9             zvuk = 1;
	RCALL SUBOPT_0x11
; 0000 02EA             delay_ms(50);
; 0000 02EB             zvuk = 0;
; 0000 02EC             }
	RJMP _0x133
_0x135:
; 0000 02ED          #asm("cli")                     //    
	cli
; 0000 02EE             DDRC=DDRB=DDRD=0;
	LDI  R30,LOW(0)
	OUT  0x11,R30
	OUT  0x17,R30
	OUT  0x14,R30
; 0000 02EF             PORTC=PORTD=0;
	OUT  0x12,R30
	OUT  0x15,R30
; 0000 02F0             PORTB=0x01;
	LDI  R30,LOW(1)
	OUT  0x18,R30
; 0000 02F1             ADMUX=31;
	LDI  R30,LOW(31)
	OUT  0x7,R30
; 0000 02F2             ADCSRA=0x00;
	LDI  R30,LOW(0)
	OUT  0x6,R30
; 0000 02F3             WDTCR=0x1F;
	LDI  R30,LOW(31)
	OUT  0x21,R30
; 0000 02F4             WDTCR=0x00;
	LDI  R30,LOW(0)
	OUT  0x21,R30
; 0000 02F5             MCUCR = 0x20;
	LDI  R30,LOW(32)
	OUT  0x35,R30
; 0000 02F6             MCUCSR = 0;
	LDI  R30,LOW(0)
	OUT  0x34,R30
; 0000 02F7             sleep_enable(); //  
	RCALL _sleep_enable
; 0000 02F8             powerdown();
	RCALL _powerdown
; 0000 02F9 
; 0000 02FA 
; 0000 02FB          };
_0x121:
; 0000 02FC         };
_0x117:
; 0000 02FD      lcd_gotoxy(0,0);
	RCALL SUBOPT_0x1
	LDI  R26,LOW(0)
	RCALL _lcd_gotoxy
; 0000 02FE         if (m>220) lcd_putsf(" ! HET  KOHTAKTA");
	LDI  R30,LOW(220)
	LDI  R31,HIGH(220)
	CP   R30,R4
	CPC  R31,R5
	BRSH _0x13A
	__POINTW2FN _0x0,150
	RJMP _0x155
; 0000 02FF         else
_0x13A:
; 0000 0300         {
; 0000 0301         vrem0 = (float)d/40;
	RCALL SUBOPT_0x14
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x42200000
	RCALL __DIVF21
	RCALL SUBOPT_0x15
; 0000 0302         ftoa(vrem0,1,tok0);
	LDI  R30,LOW(1)
	RCALL SUBOPT_0x16
; 0000 0303         lcd_putsf("I=");
	__POINTW2FN _0x0,167
	RCALL _lcd_putsf
; 0000 0304         if (vrem0 == 0) lcd_putsf("0.0"); else  lcd_puts(tok0);
	LDS  R30,_vrem0
	LDS  R31,_vrem0+1
	LDS  R22,_vrem0+2
	LDS  R23,_vrem0+3
	RCALL __CPD10
	BRNE _0x13C
	__POINTW2FN _0x0,170
	RCALL _lcd_putsf
	RJMP _0x13D
_0x13C:
	LDI  R26,LOW(_tok0)
	LDI  R27,HIGH(_tok0)
	RCALL _lcd_puts
; 0000 0305         lcd_putsf(" mA");
_0x13D:
	__POINTW2FN _0x0,5
	RCALL _lcd_putsf
; 0000 0306 
; 0000 0307             if (++kluch)
	LDI  R30,LOW(32)
	EOR  R2,R30
	BST  R2,5
	LDI  R30,LOW(0)
	BLD  R30,0
	CPI  R30,0
	BRNE PC+2
	RJMP _0x13E
; 0000 0308             {
; 0000 0309             time0 = (3650 - time)/2;
	RCALL SUBOPT_0x2B
	LDI  R30,LOW(3650)
	LDI  R31,HIGH(3650)
	SUB  R30,R26
	SBC  R31,R27
	LSR  R31
	ROR  R30
	RCALL SUBOPT_0x2D
; 0000 030A             vrem = time0/60;
	RCALL SUBOPT_0x2C
	LDI  R30,LOW(60)
	LDI  R31,HIGH(60)
	RCALL __DIVW21U
	RCALL SUBOPT_0x7
; 0000 030B             itoa(vrem,minut);
	RCALL SUBOPT_0x8
	RCALL SUBOPT_0x3
	LDI  R26,LOW(_minut)
	LDI  R27,HIGH(_minut)
	RCALL _itoa
; 0000 030C             lcd_putsf("Bp.");
	__POINTW2FN _0x0,174
	RCALL _lcd_putsf
; 0000 030D             if (vrem<10) { lcd_putsf("0");minut[1] = 0;}else minut[2]=0;
	RCALL SUBOPT_0x9
	CPI  R26,LOW(0xA)
	BRSH _0x13F
	RCALL SUBOPT_0x32
	__PUTB1MN _minut,1
	RJMP _0x140
_0x13F:
	LDI  R30,LOW(0)
	__PUTB1MN _minut,2
; 0000 030E             lcd_puts(minut);
_0x140:
	LDI  R26,LOW(_minut)
	LDI  R27,HIGH(_minut)
	RCALL _lcd_puts
; 0000 030F             vrem = time0 - (int)vrem * 60;
	RCALL SUBOPT_0x8
	LDI  R26,LOW(60)
	MULS R30,R26
	MOVW R30,R0
	LDS  R26,_time0
	SUB  R26,R30
	STS  _vrem,R26
; 0000 0310             itoa(vrem,sek);
	RCALL SUBOPT_0x8
	RCALL SUBOPT_0x3
	RCALL SUBOPT_0x4
	RCALL _itoa
; 0000 0311             lcd_putsf(":");
	__POINTW2FN _0x0,178
	RCALL _lcd_putsf
; 0000 0312             if (vrem<10) { lcd_putsf("0");sek[1] = 0;}else sek[2]=0;
	RCALL SUBOPT_0x9
	CPI  R26,LOW(0xA)
	BRSH _0x141
	RCALL SUBOPT_0x32
	__PUTB1MN _sek,1
	RJMP _0x142
_0x141:
	LDI  R30,LOW(0)
	__PUTB1MN _sek,2
; 0000 0313             lcd_puts(sek);
_0x142:
	RCALL SUBOPT_0x4
	RCALL _lcd_puts
; 0000 0314             }
; 0000 0315             else
	RJMP _0x143
_0x13E:
; 0000 0316             {
; 0000 0317             lcd_gotoxy(5,1);
	LDI  R30,LOW(5)
	ST   -Y,R30
	LDI  R26,LOW(1)
	RCALL _lcd_gotoxy
; 0000 0318             lcd_putsf(" ");
	__POINTW2FN _0x0,25
_0x155:
	RCALL _lcd_putsf
; 0000 0319             };
_0x143:
; 0000 031A         };
; 0000 031B     }
; 0000 031C     else
	RJMP _0x144
_0xEC:
; 0000 031D     {
; 0000 031E     while ((dob&&ubr)&&(d++<2000));
_0x145:
	SBIS 0x16,6
	RJMP _0x148
	SBIC 0x16,7
	RJMP _0x149
_0x148:
	RJMP _0x14A
_0x149:
	MOVW R30,R6
	ADIW R30,1
	MOVW R6,R30
	SBIW R30,1
	CPI  R30,LOW(0x7D0)
	LDI  R26,HIGH(0x7D0)
	CPC  R31,R26
	BRLO _0x14B
_0x14A:
	RJMP _0x147
_0x14B:
	RJMP _0x145
_0x147:
; 0000 031F     d=0;
	CLR  R6
	CLR  R7
; 0000 0320     if (time++>3700)l=1;
	RCALL SUBOPT_0x31
	SBIW R30,1
	CPI  R30,LOW(0xE75)
	LDI  R26,HIGH(0xE75)
	CPC  R31,R26
	BRLO _0x14C
	SET
	BLD  R2,2
; 0000 0321     };
_0x14C:
_0x144:
; 0000 0322 
; 0000 0323       };
	RJMP _0xB7
; 0000 0324 }
_0x14D:
	RJMP _0x14D
; .FEND
    .equ __lcd_direction=__lcd_port-1
    .equ __lcd_pin=__lcd_port-2
    .equ __lcd_rs=0
    .equ __lcd_rd=1
    .equ __lcd_enable=2
    .equ __lcd_busy_flag=7

	.DSEG

	.CSEG
__lcd_delay_G100:
; .FSTART __lcd_delay_G100
    ldi   r31,15
__lcd_delay0:
    dec   r31
    brne  __lcd_delay0
	RET
; .FEND
__lcd_ready:
; .FSTART __lcd_ready
    in    r26,__lcd_direction
    andi  r26,0xf                 ;set as input
    out   __lcd_direction,r26
    sbi   __lcd_port,__lcd_rd     ;RD=1
    cbi   __lcd_port,__lcd_rs     ;RS=0
__lcd_busy:
	RCALL __lcd_delay_G100
    sbi   __lcd_port,__lcd_enable ;EN=1
	RCALL __lcd_delay_G100
    in    r26,__lcd_pin
    cbi   __lcd_port,__lcd_enable ;EN=0
	RCALL __lcd_delay_G100
    sbi   __lcd_port,__lcd_enable ;EN=1
	RCALL __lcd_delay_G100
    cbi   __lcd_port,__lcd_enable ;EN=0
    sbrc  r26,__lcd_busy_flag
    rjmp  __lcd_busy
	RET
; .FEND
__lcd_write_nibble_G100:
; .FSTART __lcd_write_nibble_G100
    andi  r26,0xf0
    or    r26,r27
    out   __lcd_port,r26          ;write
    sbi   __lcd_port,__lcd_enable ;EN=1
	RCALL __lcd_delay_G100
    cbi   __lcd_port,__lcd_enable ;EN=0
	RCALL __lcd_delay_G100
	RET
; .FEND
__lcd_write_data:
; .FSTART __lcd_write_data
	ST   -Y,R26
    cbi  __lcd_port,__lcd_rd 	  ;RD=0
    in    r26,__lcd_direction
    ori   r26,0xf0 | (1<<__lcd_rs) | (1<<__lcd_rd) | (1<<__lcd_enable) ;set as output
    out   __lcd_direction,r26
    in    r27,__lcd_port
    andi  r27,0xf
    ld    r26,y
	RCALL __lcd_write_nibble_G100
    ld    r26,y
    swap  r26
	RCALL __lcd_write_nibble_G100
    sbi   __lcd_port,__lcd_rd     ;RD=1
	RJMP _0x20C0004
; .FEND
__lcd_read_nibble_G100:
; .FSTART __lcd_read_nibble_G100
    sbi   __lcd_port,__lcd_enable ;EN=1
	RCALL __lcd_delay_G100
    in    r30,__lcd_pin           ;read
    cbi   __lcd_port,__lcd_enable ;EN=0
	RCALL __lcd_delay_G100
    andi  r30,0xf0
	RET
; .FEND
_lcd_read_byte0_G100:
; .FSTART _lcd_read_byte0_G100
	RCALL __lcd_delay_G100
	RCALL __lcd_read_nibble_G100
    mov   r26,r30
	RCALL __lcd_read_nibble_G100
    cbi   __lcd_port,__lcd_rd     ;RD=0
    swap  r30
    or    r30,r26
	RET
; .FEND
_lcd_gotoxy:
; .FSTART _lcd_gotoxy
	ST   -Y,R26
	RCALL __lcd_ready
	LD   R30,Y
	LDI  R31,0
	SUBI R30,LOW(-__base_y_G100)
	SBCI R31,HIGH(-__base_y_G100)
	LD   R30,Z
	LDD  R26,Y+1
	ADD  R26,R30
	RCALL __lcd_write_data
	LDD  R30,Y+1
	STS  __lcd_x,R30
	LD   R30,Y
	STS  __lcd_y,R30
	ADIW R28,2
	RET
; .FEND
_lcd_clear:
; .FSTART _lcd_clear
	RCALL __lcd_ready
	LDI  R26,LOW(2)
	RCALL __lcd_write_data
	RCALL __lcd_ready
	LDI  R26,LOW(12)
	RCALL __lcd_write_data
	RCALL __lcd_ready
	LDI  R26,LOW(1)
	RCALL __lcd_write_data
	LDI  R30,LOW(0)
	STS  __lcd_y,R30
	STS  __lcd_x,R30
	RET
; .FEND
_lcd_putchar:
; .FSTART _lcd_putchar
	ST   -Y,R26
    push r30
    push r31
    ld   r26,y
    set
    cpi  r26,10
    breq __lcd_putchar1
    clt
	LDS  R30,__lcd_maxx
	LDS  R26,__lcd_x
	CP   R26,R30
	BRLO _0x2000004
	__lcd_putchar1:
	LDS  R30,__lcd_y
	SUBI R30,-LOW(1)
	STS  __lcd_y,R30
	RCALL SUBOPT_0x1
	LDS  R26,__lcd_y
	RCALL _lcd_gotoxy
	brts __lcd_putchar0
_0x2000004:
	LDS  R30,__lcd_x
	SUBI R30,-LOW(1)
	STS  __lcd_x,R30
    rcall __lcd_ready
    sbi  __lcd_port,__lcd_rs ;RS=1
	LD   R26,Y
	RCALL __lcd_write_data
__lcd_putchar0:
    pop  r31
    pop  r30
	RJMP _0x20C0004
; .FEND
_lcd_puts:
; .FSTART _lcd_puts
	ST   -Y,R27
	ST   -Y,R26
	ST   -Y,R17
_0x2000005:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	LD   R30,X+
	STD  Y+1,R26
	STD  Y+1+1,R27
	MOV  R17,R30
	CPI  R30,0
	BREQ _0x2000007
	MOV  R26,R17
	RCALL _lcd_putchar
	RJMP _0x2000005
_0x2000007:
	RJMP _0x20C0005
; .FEND
_lcd_putsf:
; .FSTART _lcd_putsf
	RCALL SUBOPT_0x33
	ST   -Y,R17
_0x2000008:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,1
	STD  Y+1,R30
	STD  Y+1+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R17,R30
	CPI  R30,0
	BREQ _0x200000A
	MOV  R26,R17
	RCALL _lcd_putchar
	RJMP _0x2000008
_0x200000A:
_0x20C0005:
	LDD  R17,Y+0
	ADIW R28,3
	RET
; .FEND
__long_delay_G100:
; .FSTART __long_delay_G100
    clr   r26
    clr   r27
__long_delay0:
    sbiw  r26,1         ;2 cycles
    brne  __long_delay0 ;2 cycles
	RET
; .FEND
__lcd_init_write_G100:
; .FSTART __lcd_init_write_G100
	ST   -Y,R26
    cbi  __lcd_port,__lcd_rd 	  ;RD=0
    in    r26,__lcd_direction
    ori   r26,0xf7                ;set as output
    out   __lcd_direction,r26
    in    r27,__lcd_port
    andi  r27,0xf
    ld    r26,y
	RCALL __lcd_write_nibble_G100
    sbi   __lcd_port,__lcd_rd     ;RD=1
	RJMP _0x20C0004
; .FEND
_lcd_init:
; .FSTART _lcd_init
	ST   -Y,R26
    cbi   __lcd_port,__lcd_enable ;EN=0
    cbi   __lcd_port,__lcd_rs     ;RS=0
	LD   R30,Y
	STS  __lcd_maxx,R30
	SUBI R30,-LOW(128)
	__PUTB1MN __base_y_G100,2
	LD   R30,Y
	SUBI R30,-LOW(192)
	__PUTB1MN __base_y_G100,3
	RCALL SUBOPT_0x34
	RCALL SUBOPT_0x34
	RCALL SUBOPT_0x34
	RCALL __long_delay_G100
	LDI  R26,LOW(32)
	RCALL __lcd_init_write_G100
	RCALL __long_delay_G100
	LDI  R26,LOW(40)
	RCALL __lcd_write_data
	RCALL __long_delay_G100
	LDI  R26,LOW(4)
	RCALL __lcd_write_data
	RCALL __long_delay_G100
	LDI  R26,LOW(133)
	RCALL __lcd_write_data
	RCALL __long_delay_G100
    in    r26,__lcd_direction
    andi  r26,0xf                 ;set as input
    out   __lcd_direction,r26
    sbi   __lcd_port,__lcd_rd     ;RD=1
	RCALL _lcd_read_byte0_G100
	CPI  R30,LOW(0x5)
	BREQ _0x200000B
	LDI  R30,LOW(0)
	RJMP _0x20C0004
_0x200000B:
	RCALL __lcd_ready
	LDI  R26,LOW(6)
	RCALL __lcd_write_data
	RCALL _lcd_clear
	LDI  R30,LOW(1)
_0x20C0004:
	ADIW R28,1
	RET
; .FEND
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG
_sleep_enable:
; .FSTART _sleep_enable
   in   r30,power_ctrl_reg
   sbr  r30,__se_bit
   out  power_ctrl_reg,r30
	RET
; .FEND
_powerdown:
; .FSTART _powerdown
   in   r30,power_ctrl_reg
   cbr  r30,__sm_mask
   sbr  r30,__sm_powerdown
   out  power_ctrl_reg,r30
   in   r30,sreg
   sei
   sleep
   out  sreg,r30
	RET
; .FEND

	.CSEG
_itoa:
; .FSTART _itoa
	RCALL SUBOPT_0x33
    ld   r26,y+
    ld   r27,y+
    ld   r30,y+
    ld   r31,y+
    adiw r30,0
    brpl __itoa0
    com  r30
    com  r31
    adiw r30,1
    ldi  r22,'-'
    st   x+,r22
__itoa0:
    clt
    ldi  r24,low(10000)
    ldi  r25,high(10000)
    rcall __itoa1
    ldi  r24,low(1000)
    ldi  r25,high(1000)
    rcall __itoa1
    ldi  r24,100
    clr  r25
    rcall __itoa1
    ldi  r24,10
    rcall __itoa1
    mov  r22,r30
    rcall __itoa5
    clr  r22
    st   x,r22
    ret

__itoa1:
    clr	 r22
__itoa2:
    cp   r30,r24
    cpc  r31,r25
    brlo __itoa3
    inc  r22
    sub  r30,r24
    sbc  r31,r25
    brne __itoa2
__itoa3:
    tst  r22
    brne __itoa4
    brts __itoa5
    ret
__itoa4:
    set
__itoa5:
    subi r22,-0x30
    st   x+,r22
    ret
; .FEND
_ftoa:
; .FSTART _ftoa
	RCALL SUBOPT_0x33
	SBIW R28,4
	LDI  R30,LOW(0)
	ST   Y,R30
	STD  Y+1,R30
	STD  Y+2,R30
	LDI  R30,LOW(63)
	STD  Y+3,R30
	RCALL __SAVELOCR2
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	CPI  R30,LOW(0xFFFF)
	LDI  R26,HIGH(0xFFFF)
	CPC  R31,R26
	BRNE _0x204000D
	RCALL SUBOPT_0x35
	__POINTW2FN _0x2040000,0
	RCALL _strcpyf
	RJMP _0x20C0003
_0x204000D:
	CPI  R30,LOW(0x7FFF)
	LDI  R26,HIGH(0x7FFF)
	CPC  R31,R26
	BRNE _0x204000C
	RCALL SUBOPT_0x35
	__POINTW2FN _0x2040000,1
	RCALL _strcpyf
	RJMP _0x20C0003
_0x204000C:
	LDD  R26,Y+12
	TST  R26
	BRPL _0x204000F
	RCALL SUBOPT_0x36
	RCALL __ANEGF1
	RCALL SUBOPT_0x37
	RCALL SUBOPT_0x38
	LDI  R30,LOW(45)
	ST   X,R30
_0x204000F:
	LDD  R26,Y+8
	CPI  R26,LOW(0x7)
	BRLO _0x2040010
	LDI  R30,LOW(6)
	STD  Y+8,R30
_0x2040010:
	LDD  R17,Y+8
_0x2040011:
	MOV  R30,R17
	SUBI R17,1
	CPI  R30,0
	BREQ _0x2040013
	RCALL SUBOPT_0x39
	RCALL SUBOPT_0x3A
	RCALL SUBOPT_0x3B
	RJMP _0x2040011
_0x2040013:
	RCALL SUBOPT_0x3C
	RCALL __ADDF12
	RCALL SUBOPT_0x37
	LDI  R17,LOW(0)
	__GETD1N 0x3F800000
	RCALL SUBOPT_0x3B
_0x2040014:
	RCALL SUBOPT_0x3C
	RCALL __CMPF12
	BRLO _0x2040016
	RCALL SUBOPT_0x39
	RCALL SUBOPT_0x3D
	RCALL SUBOPT_0x3B
	SUBI R17,-LOW(1)
	CPI  R17,39
	BRLO _0x2040017
	RCALL SUBOPT_0x35
	__POINTW2FN _0x2040000,5
	RCALL _strcpyf
	RJMP _0x20C0003
_0x2040017:
	RJMP _0x2040014
_0x2040016:
	CPI  R17,0
	BRNE _0x2040018
	RCALL SUBOPT_0x38
	LDI  R30,LOW(48)
	ST   X,R30
	RJMP _0x2040019
_0x2040018:
_0x204001A:
	MOV  R30,R17
	SUBI R17,1
	CPI  R30,0
	BREQ _0x204001C
	RCALL SUBOPT_0x39
	RCALL SUBOPT_0x3A
	__GETD2N 0x3F000000
	RCALL __ADDF12
	MOVW R26,R30
	MOVW R24,R22
	RCALL _floor
	RCALL SUBOPT_0x3B
	RCALL SUBOPT_0x3C
	RCALL __DIVF21
	RCALL __CFD1U
	MOV  R16,R30
	RCALL SUBOPT_0x38
	RCALL SUBOPT_0x3E
	RCALL SUBOPT_0x39
	RCALL __CWD1
	RCALL __CDF1
	RCALL __MULF12
	RCALL SUBOPT_0x3F
	RCALL __SWAPD12
	RCALL __SUBF12
	RCALL SUBOPT_0x37
	RJMP _0x204001A
_0x204001C:
_0x2040019:
	LDD  R30,Y+8
	CPI  R30,0
	BREQ _0x20C0002
	RCALL SUBOPT_0x38
	LDI  R30,LOW(46)
	ST   X,R30
_0x204001E:
	LDD  R30,Y+8
	SUBI R30,LOW(1)
	STD  Y+8,R30
	SUBI R30,-LOW(1)
	BREQ _0x2040020
	RCALL SUBOPT_0x3F
	RCALL SUBOPT_0x3D
	RCALL SUBOPT_0x37
	RCALL SUBOPT_0x36
	RCALL __CFD1U
	MOV  R16,R30
	RCALL SUBOPT_0x38
	RCALL SUBOPT_0x3E
	RCALL SUBOPT_0x3F
	RCALL __CWD1
	RCALL __CDF1
	RCALL __SWAPD12
	RCALL __SUBF12
	RCALL SUBOPT_0x37
	RJMP _0x204001E
_0x2040020:
_0x20C0002:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LDI  R30,LOW(0)
	ST   X,R30
_0x20C0003:
	RCALL __LOADLOCR2
	ADIW R28,13
	RET
; .FEND

	.DSEG

	.CSEG

	.CSEG

	.CSEG
_ftrunc:
; .FSTART _ftrunc
	RCALL __PUTPARD2
   ldd  r23,y+3
   ldd  r22,y+2
   ldd  r31,y+1
   ld   r30,y
   bst  r23,7
   lsl  r23
   sbrc r22,7
   sbr  r23,1
   mov  r25,r23
   subi r25,0x7e
   breq __ftrunc0
   brcs __ftrunc0
   cpi  r25,24
   brsh __ftrunc1
   clr  r26
   clr  r27
   clr  r24
__ftrunc2:
   sec
   ror  r24
   ror  r27
   ror  r26
   dec  r25
   brne __ftrunc2
   and  r30,r26
   and  r31,r27
   and  r22,r24
   rjmp __ftrunc1
__ftrunc0:
   clt
   clr  r23
   clr  r30
   clr  r31
   clr  r22
__ftrunc1:
   cbr  r22,0x80
   lsr  r23
   brcc __ftrunc3
   sbr  r22,0x80
__ftrunc3:
   bld  r23,7
   ld   r26,y+
   ld   r27,y+
   ld   r24,y+
   ld   r25,y+
   cp   r30,r26
   cpc  r31,r27
   cpc  r22,r24
   cpc  r23,r25
   bst  r25,7
   ret
; .FEND
_floor:
; .FSTART _floor
	RCALL __PUTPARD2
	RCALL __GETD2S0
	RCALL _ftrunc
	RCALL __PUTD1S0
    brne __floor1
__floor0:
	RCALL SUBOPT_0x40
	RJMP _0x20C0001
__floor1:
    brtc __floor0
	RCALL SUBOPT_0x40
	__GETD2N 0x3F800000
	RCALL __SUBF12
_0x20C0001:
	ADIW R28,4
	RET
; .FEND

	.CSEG
_strcpyf:
; .FSTART _strcpyf
	RCALL SUBOPT_0x33
    ld   r30,y+
    ld   r31,y+
    ld   r26,y+
    ld   r27,y+
    movw r24,r26
strcpyf0:
	lpm  r0,z+
    st   x+,r0
    tst  r0
    brne strcpyf0
    movw r30,r24
    ret
; .FEND

	.ESEG
_seans1:
	.DB  0x0
_seans2:
	.DB  0x0
_bol1:
	.BYTE 0x1
_bol2:
	.BYTE 0x1

	.DSEG
_time:
	.BYTE 0x2
_time0:
	.BYTE 0x2
_paus:
	.BYTE 0x4
_minut:
	.BYTE 0x3
_sek:
	.BYTE 0x3
_tok0:
	.BYTE 0x4
_vrem:
	.BYTE 0x1
_rezh0:
	.BYTE 0x1
_seans:
	.BYTE 0x1
_bol:
	.BYTE 0x1
_i:
	.BYTE 0x1
_vrem0:
	.BYTE 0x4
__base_y_G100:
	.BYTE 0x4
__lcd_x:
	.BYTE 0x1
__lcd_y:
	.BYTE 0x1
__lcd_maxx:
	.BYTE 0x1
__seed_G102:
	.BYTE 0x4

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x0:
	SBI  0x18,0
	LDI  R30,LOW(0)
	OUT  0x2F,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1:
	LDI  R30,LOW(0)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x2:
	LDS  R30,_bol
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3:
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4:
	LDI  R26,LOW(_sek)
	LDI  R27,HIGH(_sek)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x5:
	RCALL SUBOPT_0x2
	LDI  R26,LOW(26)
	MUL  R30,R26
	MOVW R30,R0
	SUBI R30,LOW(-_bolezni*2)
	SBCI R31,HIGH(-_bolezni*2)
	MOVW R26,R30
	LDS  R30,_vrem
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x6:
	ADD  R30,R26
	ADC  R31,R27
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x7:
	STS  _vrem,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x8:
	LDS  R30,_vrem
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x9:
	LDS  R26,_vrem
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xA:
	STS  _bol,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xB:
	LDI  R30,LOW(0)
	RJMP SUBOPT_0x7

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:30 WORDS
SUBOPT_0xC:
	LDI  R30,LOW(0)
	STS  _paus,R30
	STS  _paus+1,R30
	STS  _paus+2,R30
	STS  _paus+3,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0xD:
	LDI  R26,LOW(_paus)
	LDI  R27,HIGH(_paus)
	RCALL __GETD1P_INC
	__SUBD1N -1
	RCALL __PUTDP1_DEC
	SBIW R30,1
	SBCI R22,0
	SBCI R23,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 12 TIMES, CODE SIZE REDUCTION:20 WORDS
SUBOPT_0xE:
	LDI  R26,LOW(100)
	LDI  R27,0
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xF:
	LDI  R30,0
	SBIS 0x16,7
	LDI  R30,1
	MOV  R0,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:19 WORDS
SUBOPT_0x10:
	LDS  R26,_paus
	LDS  R27,_paus+1
	LDS  R24,_paus+2
	LDS  R25,_paus+3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 17 TIMES, CODE SIZE REDUCTION:62 WORDS
SUBOPT_0x11:
	SBI  0x17,1
	LDI  R26,LOW(50)
	LDI  R27,0
	RCALL _delay_ms
	CBI  0x17,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 12 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x12:
	LDI  R27,0
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x13:
	LDI  R30,LOW(0)
	STS  _time,R30
	STS  _time+1,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x14:
	MOVW R30,R6
	CLR  R22
	CLR  R23
	RCALL __CDF1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:14 WORDS
SUBOPT_0x15:
	STS  _vrem0,R30
	STS  _vrem0+1,R31
	STS  _vrem0+2,R22
	STS  _vrem0+3,R23
	RCALL __PUTPARD1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x16:
	ST   -Y,R30
	LDI  R26,LOW(_tok0)
	LDI  R27,HIGH(_tok0)
	RJMP _ftoa

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:36 WORDS
SUBOPT_0x17:
	LDS  R30,_paus
	LDS  R31,_paus+1
	LDS  R22,_paus+2
	LDS  R23,_paus+3
	__ADDD1N 1
	STS  _paus,R30
	STS  _paus+1,R31
	STS  _paus+2,R22
	STS  _paus+3,R23
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x18:
	LDI  R26,LOW(50)
	RJMP SUBOPT_0x12

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x19:
	LDI  R26,LOW(400)
	LDI  R27,HIGH(400)
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x1A:
	RCALL SUBOPT_0x10
	__CPD2N 0xF4240
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1B:
	LDI  R26,LOW(_seans2)
	LDI  R27,HIGH(_seans2)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1C:
	LDI  R26,LOW(_seans1)
	LDI  R27,HIGH(_seans1)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x1D:
	RCALL SUBOPT_0x2
	LDI  R26,LOW(20)
	MUL  R30,R26
	MOVW R30,R0
	SUBI R30,LOW(-_rezhimi*2)
	SBCI R31,HIGH(-_rezhimi*2)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1E:
	LPM  R0,Z
	STS  _rezh0,R0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1F:
	LDS  R30,_seans
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x20:
	MOVW R30,R8
	ADIW R30,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x21:
	LDS  R26,_seans
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x22:
	LDS  R26,_rezh0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x23:
	SBI  0x18,5
	SET
	BLD  R2,4
	CLT
	BLD  R2,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x24:
	CLT
	BLD  R2,4
	CBI  0x18,5
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x25:
	RCALL _lcd_clear
	__POINTW2FN _0x0,110
	RJMP _lcd_putsf

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x26:
	__POINTW2FN _0x0,117
	RJMP _lcd_putsf

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x27:
	__POINTW2FN _0x0,128
	RJMP _lcd_putsf

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x28:
	__POINTW2FN _0x0,139
	RJMP _lcd_putsf

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:16 WORDS
SUBOPT_0x29:
	LDI  R26,0
	SBRC R2,1
	LDI  R26,1
	LDI  R30,0
	SBRC R2,4
	LDI  R30,1
	OR   R30,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x2A:
	CBI  0x17,1
	RJMP SUBOPT_0xE

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:10 WORDS
SUBOPT_0x2B:
	LDS  R26,_time
	LDS  R27,_time+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:16 WORDS
SUBOPT_0x2C:
	LDS  R26,_time0
	LDS  R27,_time0+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:16 WORDS
SUBOPT_0x2D:
	STS  _time0,R30
	STS  _time0+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x2E:
	RCALL __MULB1W2U
	MOVW R26,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2F:
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	RCALL __DIVW21U
	RJMP SUBOPT_0x2D

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x30:
	LDI  R30,LOW(3)
	LDI  R31,HIGH(3)
	RCALL __DIVW21U
	RJMP SUBOPT_0x2D

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x31:
	LDI  R26,LOW(_time)
	LDI  R27,HIGH(_time)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x32:
	__POINTW2FN _0x0,172
	RCALL _lcd_putsf
	LDI  R30,LOW(0)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x33:
	ST   -Y,R27
	ST   -Y,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x34:
	RCALL __long_delay_G100
	LDI  R26,LOW(48)
	RJMP __lcd_init_write_G100

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x35:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x36:
	__GETD1S 9
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:10 WORDS
SUBOPT_0x37:
	__PUTD1S 9
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x38:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,1
	STD  Y+6,R26
	STD  Y+6+1,R27
	SBIW R26,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x39:
	__GETD2S 2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3A:
	__GETD1N 0x3DCCCCCD
	RCALL __MULF12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x3B:
	__PUTD1S 2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0x3C:
	__GETD1S 2
	__GETD2S 9
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3D:
	__GETD1N 0x41200000
	RCALL __MULF12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3E:
	MOV  R30,R16
	SUBI R30,-LOW(48)
	ST   X,R30
	MOV  R30,R16
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x3F:
	__GETD2S 9
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x40:
	RCALL __GETD1S0
	RET


	.CSEG
_delay_ms:
	adiw r26,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r26,1
	brne __delay_ms0
__delay_ms1:
	ret

__ANEGF1:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __ANEGF10
	SUBI R23,0x80
__ANEGF10:
	RET

__ROUND_REPACK:
	TST  R21
	BRPL __REPACK
	CPI  R21,0x80
	BRNE __ROUND_REPACK0
	SBRS R30,0
	RJMP __REPACK
__ROUND_REPACK0:
	ADIW R30,1
	ADC  R22,R25
	ADC  R23,R25
	BRVS __REPACK1

__REPACK:
	LDI  R21,0x80
	EOR  R21,R23
	BRNE __REPACK0
	PUSH R21
	RJMP __ZERORES
__REPACK0:
	CPI  R21,0xFF
	BREQ __REPACK1
	LSL  R22
	LSL  R0
	ROR  R21
	ROR  R22
	MOV  R23,R21
	RET
__REPACK1:
	PUSH R21
	TST  R0
	BRMI __REPACK2
	RJMP __MAXRES
__REPACK2:
	RJMP __MINRES

__UNPACK:
	LDI  R21,0x80
	MOV  R1,R25
	AND  R1,R21
	LSL  R24
	ROL  R25
	EOR  R25,R21
	LSL  R21
	ROR  R24

__UNPACK1:
	LDI  R21,0x80
	MOV  R0,R23
	AND  R0,R21
	LSL  R22
	ROL  R23
	EOR  R23,R21
	LSL  R21
	ROR  R22
	RET

__CFD1U:
	SET
	RJMP __CFD1U0
__CFD1:
	CLT
__CFD1U0:
	PUSH R21
	RCALL __UNPACK1
	CPI  R23,0x80
	BRLO __CFD10
	CPI  R23,0xFF
	BRCC __CFD10
	RJMP __ZERORES
__CFD10:
	LDI  R21,22
	SUB  R21,R23
	BRPL __CFD11
	NEG  R21
	CPI  R21,8
	BRTC __CFD19
	CPI  R21,9
__CFD19:
	BRLO __CFD17
	SER  R30
	SER  R31
	SER  R22
	LDI  R23,0x7F
	BLD  R23,7
	RJMP __CFD15
__CFD17:
	CLR  R23
	TST  R21
	BREQ __CFD15
__CFD18:
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R23
	DEC  R21
	BRNE __CFD18
	RJMP __CFD15
__CFD11:
	CLR  R23
__CFD12:
	CPI  R21,8
	BRLO __CFD13
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R23
	SUBI R21,8
	RJMP __CFD12
__CFD13:
	TST  R21
	BREQ __CFD15
__CFD14:
	LSR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R21
	BRNE __CFD14
__CFD15:
	TST  R0
	BRPL __CFD16
	RCALL __ANEGD1
__CFD16:
	POP  R21
	RET

__CDF1U:
	SET
	RJMP __CDF1U0
__CDF1:
	CLT
__CDF1U0:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __CDF10
	CLR  R0
	BRTS __CDF11
	TST  R23
	BRPL __CDF11
	COM  R0
	RCALL __ANEGD1
__CDF11:
	MOV  R1,R23
	LDI  R23,30
	TST  R1
__CDF12:
	BRMI __CDF13
	DEC  R23
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R1
	RJMP __CDF12
__CDF13:
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R1
	PUSH R21
	RCALL __REPACK
	POP  R21
__CDF10:
	RET

__SWAPACC:
	PUSH R20
	MOVW R20,R30
	MOVW R30,R26
	MOVW R26,R20
	MOVW R20,R22
	MOVW R22,R24
	MOVW R24,R20
	MOV  R20,R0
	MOV  R0,R1
	MOV  R1,R20
	POP  R20
	RET

__UADD12:
	ADD  R30,R26
	ADC  R31,R27
	ADC  R22,R24
	RET

__NEGMAN1:
	COM  R30
	COM  R31
	COM  R22
	SUBI R30,-1
	SBCI R31,-1
	SBCI R22,-1
	RET

__SUBF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R25,0x80
	BREQ __ADDF129
	LDI  R21,0x80
	EOR  R1,R21

	RJMP __ADDF120

__ADDF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R25,0x80
	BREQ __ADDF129

__ADDF120:
	CPI  R23,0x80
	BREQ __ADDF128
__ADDF121:
	MOV  R21,R23
	SUB  R21,R25
	BRVS __ADDF1211
	BRPL __ADDF122
	RCALL __SWAPACC
	RJMP __ADDF121
__ADDF122:
	CPI  R21,24
	BRLO __ADDF123
	CLR  R26
	CLR  R27
	CLR  R24
__ADDF123:
	CPI  R21,8
	BRLO __ADDF124
	MOV  R26,R27
	MOV  R27,R24
	CLR  R24
	SUBI R21,8
	RJMP __ADDF123
__ADDF124:
	TST  R21
	BREQ __ADDF126
__ADDF125:
	LSR  R24
	ROR  R27
	ROR  R26
	DEC  R21
	BRNE __ADDF125
__ADDF126:
	MOV  R21,R0
	EOR  R21,R1
	BRMI __ADDF127
	RCALL __UADD12
	BRCC __ADDF129
	ROR  R22
	ROR  R31
	ROR  R30
	INC  R23
	BRVC __ADDF129
	RJMP __MAXRES
__ADDF128:
	RCALL __SWAPACC
__ADDF129:
	RCALL __REPACK
	POP  R21
	RET
__ADDF1211:
	BRCC __ADDF128
	RJMP __ADDF129
__ADDF127:
	SUB  R30,R26
	SBC  R31,R27
	SBC  R22,R24
	BREQ __ZERORES
	BRCC __ADDF1210
	COM  R0
	RCALL __NEGMAN1
__ADDF1210:
	TST  R22
	BRMI __ADDF129
	LSL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVC __ADDF1210

__ZERORES:
	CLR  R30
	CLR  R31
	CLR  R22
	CLR  R23
	POP  R21
	RET

__MINRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	SER  R23
	POP  R21
	RET

__MAXRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	LDI  R23,0x7F
	POP  R21
	RET

__MULF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BREQ __ZERORES
	CPI  R25,0x80
	BREQ __ZERORES
	EOR  R0,R1
	SEC
	ADC  R23,R25
	BRVC __MULF124
	BRLT __ZERORES
__MULF125:
	TST  R0
	BRMI __MINRES
	RJMP __MAXRES
__MULF124:
	PUSH R0
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R17
	CLR  R18
	CLR  R25
	MUL  R22,R24
	MOVW R20,R0
	MUL  R24,R31
	MOV  R19,R0
	ADD  R20,R1
	ADC  R21,R25
	MUL  R22,R27
	ADD  R19,R0
	ADC  R20,R1
	ADC  R21,R25
	MUL  R24,R30
	RCALL __MULF126
	MUL  R27,R31
	RCALL __MULF126
	MUL  R22,R26
	RCALL __MULF126
	MUL  R27,R30
	RCALL __MULF127
	MUL  R26,R31
	RCALL __MULF127
	MUL  R26,R30
	ADD  R17,R1
	ADC  R18,R25
	ADC  R19,R25
	ADC  R20,R25
	ADC  R21,R25
	MOV  R30,R19
	MOV  R31,R20
	MOV  R22,R21
	MOV  R21,R18
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	POP  R0
	TST  R22
	BRMI __MULF122
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	RJMP __MULF123
__MULF122:
	INC  R23
	BRVS __MULF125
__MULF123:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__MULF127:
	ADD  R17,R0
	ADC  R18,R1
	ADC  R19,R25
	RJMP __MULF128
__MULF126:
	ADD  R18,R0
	ADC  R19,R1
__MULF128:
	ADC  R20,R25
	ADC  R21,R25
	RET

__DIVF21:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BRNE __DIVF210
	TST  R1
__DIVF211:
	BRPL __DIVF219
	RJMP __MINRES
__DIVF219:
	RJMP __MAXRES
__DIVF210:
	CPI  R25,0x80
	BRNE __DIVF218
__DIVF217:
	RJMP __ZERORES
__DIVF218:
	EOR  R0,R1
	SEC
	SBC  R25,R23
	BRVC __DIVF216
	BRLT __DIVF217
	TST  R0
	RJMP __DIVF211
__DIVF216:
	MOV  R23,R25
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R1
	CLR  R17
	CLR  R18
	CLR  R19
	CLR  R20
	CLR  R21
	LDI  R25,32
__DIVF212:
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	CPC  R20,R17
	BRLO __DIVF213
	SUB  R26,R30
	SBC  R27,R31
	SBC  R24,R22
	SBC  R20,R17
	SEC
	RJMP __DIVF214
__DIVF213:
	CLC
__DIVF214:
	ROL  R21
	ROL  R18
	ROL  R19
	ROL  R1
	ROL  R26
	ROL  R27
	ROL  R24
	ROL  R20
	DEC  R25
	BRNE __DIVF212
	MOVW R30,R18
	MOV  R22,R1
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	TST  R22
	BRMI __DIVF215
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVS __DIVF217
__DIVF215:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__CMPF12:
	TST  R25
	BRMI __CMPF120
	TST  R23
	BRMI __CMPF121
	CP   R25,R23
	BRLO __CMPF122
	BRNE __CMPF121
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	BRLO __CMPF122
	BREQ __CMPF123
__CMPF121:
	CLZ
	CLC
	RET
__CMPF122:
	CLZ
	SEC
	RET
__CMPF123:
	SEZ
	CLC
	RET
__CMPF120:
	TST  R23
	BRPL __CMPF122
	CP   R25,R23
	BRLO __CMPF121
	BRNE __CMPF122
	CP   R30,R26
	CPC  R31,R27
	CPC  R22,R24
	BRLO __CMPF122
	BREQ __CMPF123
	RJMP __CMPF121

__ANEGD1:
	COM  R31
	COM  R22
	COM  R23
	NEG  R30
	SBCI R31,-1
	SBCI R22,-1
	SBCI R23,-1
	RET

__LSRW2:
	LSR  R31
	ROR  R30
	LSR  R31
	ROR  R30
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__LTW12U:
	CP   R26,R30
	CPC  R27,R31
	LDI  R30,1
	BRLO __LTW12UT
	CLR  R30
__LTW12UT:
	RET

__GTW12U:
	CP   R30,R26
	CPC  R31,R27
	LDI  R30,1
	BRLO __GTW12UT
	CLR  R30
__GTW12UT:
	RET

__LTD12U:
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	CPC  R25,R23
	LDI  R30,1
	BRLO __LTD12UT
	CLR  R30
__LTD12UT:
	RET

__MULB1W2U:
	MOV  R22,R30
	MUL  R22,R26
	MOVW R30,R0
	MUL  R22,R27
	ADD  R31,R0
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__GETD1P_INC:
	LD   R30,X+
	LD   R31,X+
	LD   R22,X+
	LD   R23,X+
	RET

__PUTDP1_DEC:
	ST   -X,R23
	ST   -X,R22
	ST   -X,R31
	ST   -X,R30
	RET

__GETD1S0:
	LD   R30,Y
	LDD  R31,Y+1
	LDD  R22,Y+2
	LDD  R23,Y+3
	RET

__GETD2S0:
	LD   R26,Y
	LDD  R27,Y+1
	LDD  R24,Y+2
	LDD  R25,Y+3
	RET

__PUTD1S0:
	ST   Y,R30
	STD  Y+1,R31
	STD  Y+2,R22
	STD  Y+3,R23
	RET

__PUTPARD1:
	ST   -Y,R23
	ST   -Y,R22
	ST   -Y,R31
	ST   -Y,R30
	RET

__PUTPARD2:
	ST   -Y,R25
	ST   -Y,R24
	ST   -Y,R27
	ST   -Y,R26
	RET

__SWAPD12:
	MOV  R1,R24
	MOV  R24,R22
	MOV  R22,R1
	MOV  R1,R25
	MOV  R25,R23
	MOV  R23,R1

__SWAPW12:
	MOV  R1,R27
	MOV  R27,R31
	MOV  R31,R1

__SWAPB12:
	MOV  R1,R26
	MOV  R26,R30
	MOV  R30,R1
	RET

__EEPROMRDB:
	SBIC EECR,EEWE
	RJMP __EEPROMRDB
	PUSH R31
	IN   R31,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R30,EEDR
	OUT  SREG,R31
	POP  R31
	RET

__EEPROMWRB:
	SBIS EECR,EEWE
	RJMP __EEPROMWRB1
	WDR
	RJMP __EEPROMWRB
__EEPROMWRB1:
	IN   R25,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R24,EEDR
	CP   R30,R24
	BREQ __EEPROMWRB0
	OUT  EEDR,R30
	SBI  EECR,EEMWE
	SBI  EECR,EEWE
__EEPROMWRB0:
	OUT  SREG,R25
	RET

__CPD10:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	RET

__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
