
#pragma used+
sfrb TWBR=0;
sfrb TWSR=1;
sfrb TWAR=2;
sfrb TWDR=3;
sfrb ADCL=4;
sfrb ADCH=5;
sfrw ADCW=4;      
sfrb ADCSRA=6;
sfrb ADMUX=7;
sfrb ACSR=8;
sfrb UBRRL=9;
sfrb UCSRB=0xa;
sfrb UCSRA=0xb;
sfrb UDR=0xc;
sfrb SPCR=0xd;
sfrb SPSR=0xe;
sfrb SPDR=0xf;
sfrb PIND=0x10;
sfrb DDRD=0x11;
sfrb PORTD=0x12;
sfrb PINC=0x13;
sfrb DDRC=0x14;
sfrb PORTC=0x15;
sfrb PINB=0x16;
sfrb DDRB=0x17;
sfrb PORTB=0x18;
sfrb EECR=0x1c;
sfrb EEDR=0x1d;
sfrb EEARL=0x1e;
sfrb EEARH=0x1f;
sfrw EEAR=0x1e;   
sfrb UBRRH=0x20;
sfrb UCSRC=0X20;
sfrb WDTCR=0x21;
sfrb ASSR=0x22;
sfrb OCR2=0x23;
sfrb TCNT2=0x24;
sfrb TCCR2=0x25;
sfrb ICR1L=0x26;
sfrb ICR1H=0x27;
sfrw ICR1=0x26;   
sfrb OCR1BL=0x28;
sfrb OCR1BH=0x29;
sfrw OCR1B=0x28;  
sfrb OCR1AL=0x2a;
sfrb OCR1AH=0x2b;
sfrw OCR1A=0x2a;  
sfrb TCNT1L=0x2c;
sfrb TCNT1H=0x2d;
sfrw TCNT1=0x2c;  
sfrb TCCR1B=0x2e;
sfrb TCCR1A=0x2f;
sfrb SFIOR=0x30;
sfrb OSCCAL=0x31;
sfrb TCNT0=0x32;
sfrb TCCR0=0x33;
sfrb MCUCSR=0x34;
sfrb MCUCR=0x35;
sfrb TWCR=0x36;
sfrb SPMCR=0x37;
sfrb TIFR=0x38;
sfrb TIMSK=0x39;
sfrb GIFR=0x3a;
sfrb GICR=0x3b;
sfrb SPL=0x3d;
sfrb SPH=0x3e;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
#endasm

#asm
   .equ __lcd_port=0x12 ;PORTD
#endasm

#pragma used+

void _lcd_ready(void);
void _lcd_write_data(unsigned char data);

void lcd_write_byte(unsigned char addr, unsigned char data);

unsigned char lcd_read_byte(unsigned char addr);

void lcd_gotoxy(unsigned char x, unsigned char y);

void lcd_clear(void);
void lcd_putchar(char c);

void lcd_puts(char *str);

void lcd_putsf(char flash *str);

unsigned char lcd_init(unsigned char lcd_columns);

void lcd_control (unsigned char control);

#pragma used-
#pragma library lcd.lib

#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

#pragma used+
void sleep_enable(void);
void sleep_disable(void);
#pragma used-

#pragma used+
void idle(void);

void powerdown(void);

void powersave(void);

void standby(void);

void extended_standby(void);
#pragma used-

#pragma library sleep.lib

#pragma used+

unsigned char cabs(signed char x);
unsigned int abs(int x);
unsigned long labs(long x);
float fabs(float x);
int atoi(char *str);
long int atol(char *str);
float atof(char *str);
void itoa(int n,char *str);
void ltoa(long int n,char *str);
void ftoa(float n,unsigned char decimals,char *str);
void ftoe(float n,unsigned char decimals,char *str);
void srand(int seed);
int rand(void);
void *malloc(unsigned int size);
void *calloc(unsigned int num, unsigned int size);
void *realloc(void *ptr, unsigned int size); 
void free(void *ptr);

#pragma used-
#pragma library stdlib.lib

flash char bolezni[45][26] = {"stenokardiya             ",
"IBS:stenokard s giperton.",
"IBS:ostry infarkt  miok. ",
"IBS:postinf.kardioskler. ",
"IBS:st,ned.krovoobrashc. ",
"IBS:st,kardioskl,gipert  ",
"Gipertonich. bolezn      ",
"Gipert.s entsefalopat.   ",
"Narusheniya ritma bez IBS",
"Miokardit                ",
"Porok serdtsa            ",
"Porok serdtsa s giperton ",
"Bronkhialnaya astma      ",
"Bronkhit (ostry)         ",
"Pnevmoniya.              ",
"Yazvennaya bolezn        ",
"Gastrit                  ",
"Kholetsisto-pankreatit   ",
"Kolit                    ",
"ateroskleroz sosudov mozg",
"Vertebralno-baz.nedost   ",
"Neyro-tsirkulyatorn.dist.",
"posle nar.mozg.krovoob.  ",
"Radikulit,  nevrity      ",
"Osteokhondroz pozvon.    ",
"Nevrozy                  ",
"Sakharny diabet          ",
"Prostatit                ",
"Adenoma prostaty         ",
"Piyelonefrit             ",
"Vospalitelnye zabolev.   ",
"Narush.menstrualnogo ts. ",
"Neyrodermit, ekzema      ",
"Psoriaz                  ",
"Gripp, ORVI              ",
"Tonzillit                ",
"Khirurgicheskaya  patolog",
"Travma,v tom chisle mnozh",
"Ozhogi i otmorozheniya   ",
"Artrit                   ",
"Ateroskleroz sosudov kon.",
"Gaymorit, frontit        ",
"Peridontit               ",
"Seksualnye  rasstroystva ",
"Narusheniya rechev. razv "};

flash unsigned char rezhimi[45][20] = {{1,1,1,2,2,2,2,2,3,3,1,1,1,2,2,2,3,3,3,3},
{3,3,1,2,2,3,2,3,3,3,3,3,1,2,2,3,3,3,3,3},
{1,1,1,2,2,2,2,1,1,1,1,1,1,2,2,2,2,1,1,1},
{3,3,1,2,2,2,1,3,3,3,3,3,1,2,2,2,1,3,3,3},
{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
{3,3,3,1,1,1,1,2,2,3,3,3,3,1,1,1,1,2,2,3},
{1,1,1,1,2,2,1,2,3,3,1,1,1,1,2,2,1,2,3,3},
{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
{3,3,3,1,1,1,2,1,3,3,3,3,3,1,1,1,2,1,3,3},
{1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1},
{3,3,3,3,1,2,2,3,3,3,3,3,3,3,1,2,2,3,3,3},
{3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,1,1,3,3,3},
{1,1,2,2,2,1,1,1,3,3,1,1,2,2,2,1,1,1,3,3},
{1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,2,2,1},
{1,1,1,2,2,3,3,2,2,3,1,1,1,2,2,3,3,3,3,3},
{1,1,1,2,2,2,2,1,1,1,1,1,1,2,2,2,2,1,1,1},
{1,1,1,2,2,1,2,1,3,3,1,1,1,2,2,1,2,1,3,3},
{3,3,1,2,2,2,2,2,3,3,3,3,1,2,2,2,2,2,3,3},
{1,1,1,2,2,3,3,2,1,1,1,1,1,2,2,3,3,2,1,1},
{3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3},
{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
{3,3,3,3,3,2,2,2,2,2,3,3,3,3,3,3,3,3,2,2},
{3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3},
{1,1,1,1,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2},
{3,3,1,1,2,2,2,2,1,1,3,3,1,1,2,2,2,2,1,1},
{3,3,3,3,1,1,3,3,3,3,3,3,3,3,1,1,3,3,3,3},
{1,1,2,2,2,2,3,3,3,3,1,1,2,2,2,2,3,3,3,3},
{1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,3,3,1,1},
{3,3,3,3,3,1,1,2,2,2,3,3,3,3,3,1,1,2,2,2},
{2,2,2,1,1,3,3,3,2,2,2,2,2,1,1,3,3,3,2,2},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{3,3,3,3,1,2,1,2,2,2,3,3,3,3,1,2,1,2,2,2},
{1,1,2,2,2,2,2,2,3,3,1,1,2,2,2,2,2,2,3,3},
{3,3,3,3,3,3,2,1,2,2,3,3,3,3,3,3,2,1,2,2},
{1,2,1,1,2,2,2,1,1,1,1,2,1,1,2,2,2,1,1,1},
{1,1,1,1,3,3,3,1,2,2,1,1,1,1,3,3,3,1,2,2},
{1,1,2,2,2,2,2,1,3,3,1,1,2,2,2,2,2,1,3,3},
{2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1},
{2,2,2,2,3,3,3,2,1,1,2,2,2,2,3,3,3,2,1,1},
{1,1,2,2,3,3,3,3,2,1,1,1,2,2,3,3,3,3,2,1},
{1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2},
{1,1,1,1,2,2,2,2,2,2,1,1,3,3,3,3,3,2,2,2},
{1,1,1,1,2,1,1,2,2,2,1,1,1,1,2,1,1,2,2,2},
{3,3,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
{3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3}};

eeprom char seans1=0,seans2=0, bol1, bol2;
unsigned int m,d,n,a,tok,time,time0;
unsigned long paus;
bit j,k,l,zad,k1,kluch,chel;
unsigned char minut[3],sek[3],tok0[] = "0.0",vrem, rezh0=1, seans, bol, i;
float vrem0;

unsigned int read_adc(unsigned char adc_input)
{
ADMUX=adc_input | (0xC0 & 0xff);

delay_us(10);

ADCSRA|=0x40;

while ((ADCSRA & 0x10)==0);
ADCSRA|=0x10;
return ADCW;
}

interrupt [10] void timer0_ovf_isr(void)
{

if(zad++) TCNT0 = 0xBA;        
else
{

TCNT0=0x01;             

if (a++<83)              
{
if (k&(a<82)) PORTB.4 = !PORTB.4; else PORTB.4 = 0;  
}
else
{
PORTB.4 = 1;                                     
};
if (a == 83)                   
{
d = read_adc(0);         
zad++;                         
if (d > tok)                
{
PORTB.0 = 1;
TCCR1A=0x00;
m = 0;
} else
{
if (m>220)
{
PORTB.0 = 1;
TCCR1A=0x00;
DDRB.1 = !DDRB.1;             

} else
{
if (PORTB.0 == 1)
{
PORTB.0 = 0;
TCCR1A=0x32;         

};
};
if (m>440)
{
m=0;
lcd_clear();
lcd_putsf("I=0.0 mA");
lcd_gotoxy(0,1);
};            
m++;
};
};

if (a > n) a = 0;
};
}

void lcdbol(void)
{
lcd_gotoxy(0,0);
itoa(bol,sek);
if (bol<10) lcd_putchar('0'); 
lcd_puts(sek); 
lcd_gotoxy(2,0);
for (i = 0;i < 14;i++)     
{
if(bolezni[bol][vrem+1] == 0)  
{         
vrem = 13;       

} 
else lcd_putchar(bolezni[bol][vrem++]);
}  
vrem -= 13; 
if(vrem < 2) delay_ms(1000);   
else delay_ms(500);  
}

char vibor(void)     
{
bol = 0;
lcd_clear();    
vrem = 0;       
paus = 0;
while (paus++<1000) 
{    
lcdbol();
if(!PINB.7)
{      
vrem = 0; 
delay_ms(100);              
while((!PINB.7)&(paus++ < 100000)){#asm("wdr")};
if (paus > 100000) break;
else 
{ 
DDRB.1 = 1 ;
delay_ms(50);
DDRB.1 = 0;
if (bol--==0) bol = 44;
};
paus = 0;
};
if(!PINB.6)
{         
paus = 0; 
vrem = 0;
DDRB.1 = 1 ;
delay_ms(50);
DDRB.1 = 0;
if (++bol>44) bol = 0;
}
}       

return bol;

}

void main(void)
{

PORTB=0xD1;
DDRB=0x3D;

PORTC=0b1111111;
DDRC=0x00;

PORTD=0x08;
DDRD=0x08;

TCCR0=0x01;
TCNT0=0x00;

TCCR1A=0x00;
TCCR1B=0x19;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0xA0;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x18;

ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

MCUCR=0x00;

TIMSK=0x00;

#pragma optsize-
WDTCR=0x1F;
WDTCR=0x0F;
#pragma optsize+

ACSR=0x80;
SFIOR=0x00;

ADMUX=0xC0 & 0xff;
ADCSRA=0x83;

lcd_init(8);

PORTB.4 = 1;                         
PORTB.0 = 1;                           
d = 500;
n = 290;
tok = 24;                            

#asm("sei")

DDRB.1 = 1;
delay_ms(200);
d = read_adc(0);         
for(vrem=6;vrem>0;vrem=vrem-1)
{
time = read_adc(0);
if (d>time) d=time;
};
time = 0;
DDRB.1 = 0;

vrem0 = (float)d*(    0.435   /40);                      
ftoa(vrem0,2,tok0);
lcd_clear();
if(vrem0 < 4.8)
{
lcd_putsf("Low batt");
for(d=9;d>0;d=d-1)
{
delay_ms(100);
DDRB.1 = 1;
delay_ms(50);
DDRB.1 = 0;
};
} else lcd_putsf("Battery ");
lcd_putsf("U=");
lcd_puts(tok0);
lcd_putsf(" v");
while(paus<200000)
{
#asm("wdr")
paus=paus+1;
if(!PINB.7)
{
PORTB.7 = 0;
DDRB.7 = 1;
};
};
paus=0;
lcd_gotoxy(0,1);
if (!PINB.7)
{
DDRB.7 = 0;
PORTB.7 = 1;
lcd_putsf("BAPIAHT2 ");
DDRB.1 = 1 ;
delay_ms(50);
DDRB.1 = 0;
delay_ms(50);
DDRB.1 = 1 ;
delay_ms(50);
DDRB.1 = 0;
delay_ms(300);

if (!PINB.6)
{
DDRB.1 = 1 ;
delay_ms(50);
DDRB.1 = 0;
delay_ms(400);
lcd_clear();
lcd_putsf("3AHOBO 2-HET,+DA");
while(!PINB.6) #asm("wdr");
while (PINB.7&&PINB.6&&(paus<1000000)) {#asm("wdr") paus = paus+1;};
if(!PINB.6)
{

bol2 = vibor();
DDRB.1 = 1 ;
delay_ms(50);
DDRB.1 = 0;
delay_ms(400); 
seans2 = 0;
};

};

seans = seans2;
bol = bol2;

chel = 1;
}
else
{

if (!PINB.6)
{
DDRB.1 = 1 ;
delay_ms(50);
DDRB.1 = 0;
delay_ms(400);
lcd_clear();
lcd_putsf("3AHOBO 1-HET,+DA");
while(!PINB.6) #asm("wdr");
while (PINB.7&&PINB.6&&(paus<1000000)) {#asm("wdr") paus = paus+1;}; 
if(!PINB.6)
{   

bol1 = vibor();
DDRB.1 = 1 ;
delay_ms(50);
DDRB.1 = 0;
delay_ms(400);
seans1 = 0;
rezh0 = rezhimi[bol][0];

};

};

seans=seans1;
bol = bol1;

};

if (seans == 0)
{
n=0;
lcd_clear();
lcd_putsf("  Kypc   3AHOBO!" );
while(n++<20)
{
delay_ms(50);                      
DDRB.1 = 1;
delay_ms(50);
DDRB.1 = 0;
}
n=290;
}

lcd_clear();
lcd_putsf("BAPIAHT");
lcd_putchar(chel+0x31);
lcd_putsf("CEAHC= ");
lcd_putchar(seans+0x30);
delay_ms(2000);
lcd_clear();
paus = 0;
vrem = 0;
rezh0 = rezhimi[bol][seans] ;
while (paus++<12) lcdbol();

#asm("wdr")
PORTC = 0b1000000;
DDRB.1 = 1;
delay_ms(50);
DDRB.1 = 0;
if (rezh0==3)
{
PORTB.5=1;              
k1=1;                         
k = 0;
} else
{
if (rezh0 == 2) k=1; else k = 0;        
k1=0;
PORTB.5=0;              
};
lcd_clear();
lcd_putsf(" Pe - ");
if (k) lcd_putsf("2 Mogy-10k");
if(k1) lcd_putsf("3 Tpey-HeM");
if((!k1)&&(!k)) lcd_putsf("1 POBH-HeM");
DDRB.1 = 1;              
delay_ms(50);
DDRB.1 = 0;
delay_ms(100);
DDRB.1 = k|k1;
delay_ms(50);
DDRB.1 = 0;
delay_ms(100);
DDRB.1 = k1;
delay_ms(50);
DDRB.1 = 0;

while (1)
{
#asm("wdr")

if ((!PINB.6)&(tok<300))        
{
if (l) tok = tok + 4;       
else
{
while(!PINB.6);
time = 0;
if(++rezh0 > 3) rezh0 = 1;
if (rezh0==3)
{
PORTB.5=1;              
k1=1;                         
k = 0;
} else
{
if (rezh0 == 2) k=1;  else k = 0;       
k1=0;
PORTB.5=0;              
};
lcd_clear();
lcd_putsf(" Pe - ");
if (k) lcd_putsf("2 Mogy-10k");
if(k1) lcd_putsf("3 Tpey-HeM");
if((!k1)&&(!k)) lcd_putsf("1 POBH-HeM");
DDRB.1 = 1;              
delay_ms(50);
DDRB.1 = 0;
delay_ms(100);
DDRB.1 = k|k1;
delay_ms(50);
DDRB.1 = 0;
delay_ms(100);
DDRB.1 = k1;
delay_ms(50);
DDRB.1 = 0;
};
};
if ((!PINB.7)&(tok>4))        
{
if (l) tok = tok - 4;      
else
{
while(!PINB.7);
DDRB.1 = 1;              
delay_ms(50);
DDRB.1 = 0;
delay_ms(100);
DDRB.1 = k|k1;
delay_ms(50);
DDRB.1 = 0;
delay_ms(100);
DDRB.1 = k1;
delay_ms(50);
DDRB.1 = 0;
l = 1;                        
time = 0;
TIMSK=0x01;
};
};
if(l)                         
{
DDRB.1 = 0;
delay_ms(300);               
if (n>288) j = 1;                    
if (n<220) j = 0;
if (j) n--; else n++;                
if (time == 1800)                            
{
time0 = tok;
tok = 0;
delay_ms(1000);
vrem = rezh0;
rezh0 = rezhimi[bol][seans+10];
if (rezh0==3)
{
if (vrem == 2) time0=time0*3/4;
if (vrem == 1) time0=time0*6/5 ;
PORTB.5=1;              
k1=1;                         
k = 0;
} else
{

if (rezh0 == 2)
{
if (vrem == 3) time0=time0*4/3;
if (vrem == 1) time0 = time0*5/3;
k=1;
}  else
{
if (vrem == 3) time0=time0*5/6;
if (vrem == 2) time0 = time0*3/5;
k = 0;      
};
k1=0;
PORTB.5=0;              
};
lcd_clear();
lcd_putsf(" Pe - ");
if (k) lcd_putsf("2 Mogy-10k");
if(k1) lcd_putsf("3 Tpey-HeM");
if((!k1)&&(!k)) lcd_putsf("1 POBH-HeM");
DDRB.1 = 1;              
delay_ms(50);
DDRB.1 = 0;
delay_ms(100);
DDRB.1 = k|k1;
delay_ms(50);
DDRB.1 = 0;
delay_ms(100);
DDRB.1 = k1;
delay_ms(50);
DDRB.1 = 0;
delay_ms(100);
DDRB.1 = 1;
delay_ms(1500);
DDRB.1 = 0;
tok = time0;
};
if (++time >= 3600)                        
{
DDRB.1 = !DDRB.1;                          
if (time == 3600)
{
PORTB.7=0;                         
DDRB.7=1;              
DDRB.1 = 1;                         
};
if (time > 3650)           
{
TIMSK=0x00;                            
PORTB.0 = 1;
TCCR1A=0x00;
n =0 ;
if (seans == 9)
{
while(n++<20)
{
delay_ms(50);                      
DDRB.1 = 1;
delay_ms(50);
DDRB.1 = 0;
}
n=0;
};
if(time<3700)
{
if (chel)
{
if (seans < 9) seans2 = seans + 1; else seans2 = 0;
}
else
{
if (seans < 9) seans1 = seans+1; else seans1 = 0;
};
};
while(n++<5)
{
delay_ms(100);                      
DDRB.1 = 1;
delay_ms(50);
DDRB.1 = 0;
}
#asm("cli")                     
DDRC=DDRB=DDRD=0;
PORTC=PORTD=0;
PORTB=0x01;
ADMUX=31;
ADCSRA=0x00;
WDTCR=0x1F;
WDTCR=0x00;
MCUCR = 0x20;
MCUCSR = 0;
sleep_enable(); 
powerdown();

};
};
lcd_gotoxy(0,0);
if (m>220) lcd_putsf(" ! HET  KOHTAKTA");
else
{
vrem0 = (float)d/40;
ftoa(vrem0,1,tok0);
lcd_putsf("I=");
if (vrem0 == 0) lcd_putsf("0.0"); else  lcd_puts(tok0);
lcd_putsf(" mA");

if (++kluch)
{
time0 = (3650 - time)/2;
vrem = time0/60;
itoa(vrem,minut);
lcd_putsf("Bp.");
if (vrem<10) { lcd_putsf("0");minut[1] = 0;}else minut[2]=0;
lcd_puts(minut);
vrem = time0 - (int)vrem * 60;
itoa(vrem,sek);
lcd_putsf(":");
if (vrem<10) { lcd_putsf("0");sek[1] = 0;}else sek[2]=0;
lcd_puts(sek);
}
else
{
lcd_gotoxy(5,1);
lcd_putsf(" ");
};
};
}
else
{
while ((PINB.6&&PINB.7)&&(d++<2000));
d=0;
if (time++>3700)l=1;
};

};
}
