
;CodeVisionAVR C Compiler V2.03.9 Standard
;(C) Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type              : ATtiny26L
;Clock frequency        : 8,000000 MHz
;Memory model           : Tiny
;Optimize for           : Size
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External RAM size      : 0
;Data Stack size        : 32 byte(s)
;Heap size              : 0 byte(s)
;Promote char to int    : Yes
;char is unsigned       : Yes
;global const stored in FLASH  : No
;8 bit enums            : Yes
;Smart register allocation : Off
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATtiny26L
	#pragma AVRPART MEMORY PROG_FLASH 2048
	#pragma AVRPART MEMORY EEPROM 128
	#pragma AVRPART MEMORY INT_SRAM SIZE 128
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E

	.EQU WDTCR=0x21
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU SPL=0x3D
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ANDI R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ORI  R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	LDI  R22,BYTE3(2*@0+@1)
	LDI  R23,BYTE4(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+@3)
	LDI  R@1,HIGH(@2*2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+@2
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+@3
	LDS  R@1,@2+@3+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+@1,R0
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __GETB1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOV  R30,R0
	MOV  R31,R1
	.ENDM

	.MACRO __GETB2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOV  R26,R0
	MOV  R27,R1
	.ENDM

	.MACRO __GETBRSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _m=R4
	.DEF _d=R6
	.DEF _n=R8
	.DEF _a=R10
	.DEF _tok=R12

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _timer0_ovf_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x80)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_SRAM

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0xDF)
	OUT  SPL,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x80)
	LDI  R29,HIGH(0x80)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x80

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.03.9 Standard
;Automatic Program Generator
; Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version :
;Date    : 11.09.2009
;Author  :  
;Company :   ""
;Comments:
;
;
;Chip type               : ATtiny26L
;AVR Core Clock frequency: 8,000000 MHz
;Memory model            : Tiny
;External RAM size       : 0
;Data Stack size         : 32
;*****************************************************/
;
;#include <tiny26.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_adc_noise_red=0x08
	.EQU __sm_mask=0x18
	.EQU __sm_powerdown=0x10
	.EQU __sm_standby=0x18
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <sleep.h>
;
;#define vihod PORTA.0
;#define vhod PINA.2
;//#define napr PORTA.4
;#define dob PINA.4
;#define ubr PINA.5
;
;unsigned int m,d,n,a,tok,time;
;bit j,k,l,zad,k1;
;
;#define ADC_VREF_TYPE 0x80
;
;
;// Read the AD conversion result
;unsigned int read_adc(unsigned char adc_input)
; 0000 0029 {

	.CSEG
_read_adc:
; 0000 002A ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
;	adc_input -> Y+0
	LD   R30,Y
	ORI  R30,0x80
	OUT  0x7,R30
; 0000 002B // Delay needed for the stabilization of the ADC input voltage
; 0000 002C delay_us(10);
	__DELAY_USB 27
; 0000 002D // Start the AD conversion
; 0000 002E ADCSR|=0x40;
	SBI  0x6,6
; 0000 002F // Wait for the AD conversion to complete
; 0000 0030 while ((ADCSR & 0x10)==0);
_0x3:
	SBIS 0x6,4
	RJMP _0x3
; 0000 0031 ADCSR|=0x10;
	SBI  0x6,4
; 0000 0032 return ADCW;
	IN   R30,0x4
	IN   R31,0x4+1
	ADIW R28,1
	RET
; 0000 0033 }
;
;
;
;// Timer 0 overflow interrupt service routine
;interrupt [TIM0_OVF] void timer0_ovf_isr(void)
; 0000 0039 {
_timer0_ovf_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 003A // Place your code here
; 0000 003B if(zad++) TCNT0 = 0xC7;        //       10  70-90 ( )
	BST  R2,3
	LDI  R30,LOW(8)
	EOR  R2,R30
	LDI  R30,LOW(0)
	BLD  R30,0
	CPI  R30,0
	BREQ _0x6
	LDI  R30,LOW(199)
	OUT  0x32,R30
; 0000 003C else
	RJMP _0x7
_0x6:
; 0000 003D {
; 0000 003E 
; 0000 003F TCNT0=0x01;
	LDI  R30,LOW(1)
	OUT  0x32,R30
; 0000 0040 
; 0000 0041   if (a++<83)
	__GETW1R 10,11
	ADIW R30,1
	__PUTW1R 10,11
	SBIW R30,1
	CPI  R30,LOW(0x53)
	LDI  R26,HIGH(0x53)
	CPC  R31,R26
	BRSH _0x8
; 0000 0042  {
; 0000 0043  if (k&(a<82)) vihod = !vihod; else vihod = 0;
	LDI  R30,0
	SBRC R2,1
	LDI  R30,1
	MOV  R0,R30
	__GETW2R 10,11
	LDI  R30,LOW(82)
	LDI  R31,HIGH(82)
	RCALL __LTW12U
	AND  R30,R0
	BREQ _0x9
	SBIS 0x1B,0
	RJMP _0xA
	CBI  0x1B,0
	RJMP _0xB
_0xA:
	SBI  0x1B,0
_0xB:
	RJMP _0xC
_0x9:
	CBI  0x1B,0
; 0000 0044  }
_0xC:
; 0000 0045  else
	RJMP _0xF
_0x8:
; 0000 0046  {
; 0000 0047  vihod = 1;
	SBI  0x1B,0
; 0000 0048  };
_0xF:
; 0000 0049  if (a == 83) //200)
	LDI  R30,LOW(83)
	LDI  R31,HIGH(83)
	CP   R30,R10
	CPC  R31,R11
	BRNE _0x12
; 0000 004A  {
; 0000 004B  d = read_adc(2);
	LDI  R30,LOW(2)
	ST   -Y,R30
	RCALL _read_adc
	__PUTW1R 6,7
; 0000 004C  zad++;
	LDI  R30,LOW(8)
	EOR  R2,R30
; 0000 004D     if (d > tok)
	__CPWRR 12,13,6,7
	BRSH _0x13
; 0000 004E     {
; 0000 004F     OCR1C=0x08;
	OUT  0x2B,R30
; 0000 0050     PORTA.6=0;
	CBI  0x1B,6
; 0000 0051     DDRA.7 = 0;
	CBI  0x1A,7
; 0000 0052     m = 0;
	CLR  R4
	CLR  R5
; 0000 0053     } else
	RJMP _0x18
_0x13:
; 0000 0054     {
; 0000 0055        if(m>220)
	LDI  R30,LOW(220)
	LDI  R31,HIGH(220)
	CP   R30,R4
	CPC  R31,R5
	BRSH _0x19
; 0000 0056        {
; 0000 0057        OCR1C=0x08;
	LDI  R30,LOW(8)
	OUT  0x2B,R30
; 0000 0058        DDRA.7 = !DDRA.7;
	SBIS 0x1A,7
	RJMP _0x1A
	CBI  0x1A,7
	RJMP _0x1B
_0x1A:
	SBI  0x1A,7
_0x1B:
; 0000 0059        } else
	RJMP _0x1C
_0x19:
; 0000 005A        {
; 0000 005B        OCR1C=0x60;             //   (    .( 33)
	LDI  R30,LOW(96)
	OUT  0x2B,R30
; 0000 005C        PORTA.6=1;
	SBI  0x1B,6
; 0000 005D        };
_0x1C:
; 0000 005E     if (m>440) m=0;
	LDI  R30,LOW(440)
	LDI  R31,HIGH(440)
	CP   R30,R4
	CPC  R31,R5
	BRSH _0x1F
	CLR  R4
	CLR  R5
; 0000 005F     m++;
_0x1F:
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 4,5,30,31
; 0000 0060     };
_0x18:
; 0000 0061  };
_0x12:
; 0000 0062 
; 0000 0063 
; 0000 0064 if (a > n) a = 0;
	__CPWRR 8,9,10,11
	BRSH _0x20
	CLR  R10
	CLR  R11
; 0000 0065 };
_0x20:
_0x7:
; 0000 0066 }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;
;
;
;
;// Declare your global variables here
;
;void main(void)
; 0000 006F {
_main:
; 0000 0070 // Declare your local variables here
; 0000 0071 
; 0000 0072 // Input/Output Ports initialization
; 0000 0073 // Port A initialization
; 0000 0074 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 0075 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 0076 PORTA=0b00110001;
	LDI  R30,LOW(49)
	OUT  0x1B,R30
; 0000 0077 DDRA=0b11000001;
	LDI  R30,LOW(193)
	OUT  0x1A,R30
; 0000 0078 
; 0000 0079 // Port B initialization
; 0000 007A // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=Out Func0=In
; 0000 007B // State7=T State6=T State5=T State4=T State3=T State2=T State1=0 State0=T
; 0000 007C PORTB=0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
; 0000 007D DDRB=0x82;
	LDI  R30,LOW(130)
	OUT  0x17,R30
; 0000 007E 
; 0000 007F // Timer/Counter 0 initialization
; 0000 0080 // Clock source: System Clock
; 0000 0081 // Clock value: 8000,000 kHz
; 0000 0082 TCCR0=0x01;
	LDI  R30,LOW(1)
	OUT  0x33,R30
; 0000 0083 TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x32,R30
; 0000 0084 
; 0000 0085 // Timer/Counter 1 initialization
; 0000 0086 // Clock source: System Clock
; 0000 0087 // Clock value: 4000,000 kHz
; 0000 0088 // Mode: Fast PWMA top=OCR1C
; 0000 0089 // OC1A output: Inverted, /OC1A disconnected
; 0000 008A // OC1B output: Disconnected
; 0000 008B // Timer 1 Overflow Interrupt: Off
; 0000 008C // Compare A Match Interrupt: Off
; 0000 008D // Compare B Match Interrupt: Off
; 0000 008E PLLCSR=0x00;
	OUT  0x29,R30
; 0000 008F TCCR1A=0xC2;
	LDI  R30,LOW(194)
	OUT  0x30,R30
; 0000 0090 TCCR1B=0x82;
	LDI  R30,LOW(130)
	OUT  0x2F,R30
; 0000 0091 TCNT1=0x00;
	LDI  R30,LOW(0)
	OUT  0x2E,R30
; 0000 0092 OCR1A=0x20;                      //   (    .( 33)
	LDI  R30,LOW(32)
	OUT  0x2D,R30
; 0000 0093 OCR1B=0x00;
	LDI  R30,LOW(0)
	OUT  0x2C,R30
; 0000 0094 OCR1C=0x06;                    // OCR1A=0x20; OCR1C=0x60;    220 
	LDI  R30,LOW(6)
	OUT  0x2B,R30
; 0000 0095 
; 0000 0096 // External Interrupt(s) initialization
; 0000 0097 // INT0: Off
; 0000 0098 // Interrupt on any change on pins PA3, PA6, PA7 and PB4-7: Off
; 0000 0099 // Interrupt on any change on pins PB0-3: Off
; 0000 009A GIMSK=0x00;
	LDI  R30,LOW(0)
	OUT  0x3B,R30
; 0000 009B MCUCR=0x00;
	OUT  0x35,R30
; 0000 009C 
; 0000 009D // Timer(s)/Counter(s) Interrupt(s) initialization
; 0000 009E TIMSK=0x00;
	OUT  0x39,R30
; 0000 009F 
; 0000 00A0 // Universal Serial Interface initialization
; 0000 00A1 // Mode: Disabled
; 0000 00A2 // Clock source: Register & Counter=no clk.
; 0000 00A3 // USI Counter Overflow Interrupt: Off
; 0000 00A4 USICR=0x00;
	OUT  0xD,R30
; 0000 00A5 
; 0000 00A6 // Analog Comparator initialization
; 0000 00A7 // Analog Comparator: Off
; 0000 00A8 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
; 0000 00A9 
; 0000 00AA // ADC initialization
; 0000 00AB // ADC Clock frequency: 1000,000 kHz
; 0000 00AC // ADC Voltage Reference: Int., AREF discon.
; 0000 00AD ADMUX=ADC_VREF_TYPE & 0xff;
	OUT  0x7,R30
; 0000 00AE ADCSR=0x83;
	LDI  R30,LOW(131)
	OUT  0x6,R30
; 0000 00AF 
; 0000 00B0 
; 0000 00B1 vihod = 1;
	SBI  0x1B,0
; 0000 00B2 //napr = 1;
; 0000 00B3 d = 500;
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	__PUTW1R 6,7
; 0000 00B4 n = 290;
	LDI  R30,LOW(290)
	LDI  R31,HIGH(290)
	__PUTW1R 8,9
; 0000 00B5 tok = 25;
	LDI  R30,LOW(25)
	LDI  R31,HIGH(25)
	__PUTW1R 12,13
; 0000 00B6 
; 0000 00B7 // Global enable interrupts
; 0000 00B8 #asm("sei")
	sei
; 0000 00B9 
; 0000 00BA while (1)
_0x23:
; 0000 00BB       {
; 0000 00BC       // Place your code here
; 0000 00BD       delay_ms(290);               //     
	LDI  R30,LOW(290)
	LDI  R31,HIGH(290)
	RCALL SUBOPT_0x0
; 0000 00BE  if (n>288) j = 1;
	LDI  R30,LOW(288)
	LDI  R31,HIGH(288)
	CP   R30,R8
	CPC  R31,R9
	BRSH _0x26
	SET
	BLD  R2,0
; 0000 00BF  if (n<220) j = 0;
_0x26:
	LDI  R30,LOW(220)
	LDI  R31,HIGH(220)
	CP   R8,R30
	CPC  R9,R31
	BRSH _0x27
	CLT
	BLD  R2,0
; 0000 00C0  if (j) n--; else n++;
_0x27:
	SBRS R2,0
	RJMP _0x28
	__GETW1R 8,9
	SBIW R30,1
	__PUTW1R 8,9
	RJMP _0x29
_0x28:
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 8,9,30,31
; 0000 00C1     if ((!dob)&(tok<300))
_0x29:
	LDI  R30,0
	SBIS 0x19,4
	LDI  R30,1
	MOV  R0,R30
	__GETW2R 12,13
	LDI  R30,LOW(300)
	LDI  R31,HIGH(300)
	RCALL __LTW12U
	AND  R30,R0
	BREQ _0x2A
; 0000 00C2     {
; 0000 00C3         if (l) tok = tok + 5;
	SBRS R2,2
	RJMP _0x2B
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	__ADDWRR 12,13,30,31
; 0000 00C4         else
	RJMP _0x2C
_0x2B:
; 0000 00C5         {
; 0000 00C6             if (k&(!k1))
	RCALL SUBOPT_0x1
	LDI  R30,0
	SBRS R2,4
	LDI  R30,1
	AND  R30,R26
	BREQ _0x2D
; 0000 00C7             {
; 0000 00C8             PORTB.6=1;
	SBI  0x18,6
; 0000 00C9             k1=1;
	SET
	BLD  R2,4
; 0000 00CA             } else
	RJMP _0x30
_0x2D:
; 0000 00CB             {
; 0000 00CC             if (k1) k=1;
	SBRS R2,4
	RJMP _0x31
	SET
	BLD  R2,1
; 0000 00CD             k1=0;
_0x31:
	CLT
	BLD  R2,4
; 0000 00CE             PORTB.6=0;
	CBI  0x18,6
; 0000 00CF             };
_0x30:
; 0000 00D0         k = !k;
	LDI  R30,LOW(2)
	EOR  R2,R30
; 0000 00D1         };
_0x2C:
; 0000 00D2     };
_0x2A:
; 0000 00D3     if ((!ubr)&(tok>5))
	LDI  R30,0
	SBIS 0x19,5
	LDI  R30,1
	MOV  R0,R30
	__GETW2R 12,13
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	RCALL __GTW12U
	AND  R30,R0
	BREQ _0x34
; 0000 00D4     {
; 0000 00D5         if (l) tok = tok - 5;
	SBRS R2,2
	RJMP _0x35
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	__SUBWRR 12,13,30,31
; 0000 00D6         else
	RJMP _0x36
_0x35:
; 0000 00D7         {
; 0000 00D8         l = 1;
	SET
	BLD  R2,2
; 0000 00D9         time = 0;
	LDI  R30,LOW(0)
	STS  _time,R30
	STS  _time+1,R30
; 0000 00DA         TIMSK=0x02;
	LDI  R30,LOW(2)
	OUT  0x39,R30
; 0000 00DB         };
_0x36:
; 0000 00DC     };
_0x34:
; 0000 00DD     if(!l)
	SBRC R2,2
	RJMP _0x37
; 0000 00DE     {
; 0000 00DF     delay_ms(200);
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	RCALL SUBOPT_0x0
; 0000 00E0     DDRA.7 = 1;
	SBI  0x1A,7
; 0000 00E1     PORTA.6 = 1;
	SBI  0x1B,6
; 0000 00E2     delay_ms(100);
	RCALL SUBOPT_0x2
; 0000 00E3     DDRA.7 = 0;
	CBI  0x1A,7
; 0000 00E4     PORTA.6 = 0;
	CBI  0x1B,6
; 0000 00E5     delay_ms(100);
	RCALL SUBOPT_0x2
; 0000 00E6     DDRA.7 = k|k1;
	RCALL SUBOPT_0x1
	RCALL SUBOPT_0x3
	BRNE _0x40
	CBI  0x1A,7
	RJMP _0x41
_0x40:
	SBI  0x1A,7
_0x41:
; 0000 00E7     PORTA.6 = k|k1;
	RCALL SUBOPT_0x1
	RCALL SUBOPT_0x3
	BRNE _0x42
	CBI  0x1B,6
	RJMP _0x43
_0x42:
	SBI  0x1B,6
_0x43:
; 0000 00E8     delay_ms(100);
	RCALL SUBOPT_0x2
; 0000 00E9     DDRA.7 = 0;
	CBI  0x1A,7
; 0000 00EA     PORTA.6 = 0;
	CBI  0x1B,6
; 0000 00EB     delay_ms(100);
	RCALL SUBOPT_0x2
; 0000 00EC     DDRA.7 = k1;
	SBRC R2,4
	RJMP _0x48
	CBI  0x1A,7
	RJMP _0x49
_0x48:
	SBI  0x1A,7
_0x49:
; 0000 00ED     PORTA.6 = k1;
	SBRC R2,4
	RJMP _0x4A
	CBI  0x1B,6
	RJMP _0x4B
_0x4A:
	SBI  0x1B,6
_0x4B:
; 0000 00EE     delay_ms(100);
	RCALL SUBOPT_0x2
; 0000 00EF     DDRA.7 = 0;
	CBI  0x1A,7
; 0000 00F0     PORTA.6 = 0;
	CBI  0x1B,6
; 0000 00F1     } else
	RJMP _0x50
_0x37:
; 0000 00F2     {
; 0000 00F3         if (++time >= 3600)
	LDI  R26,LOW(_time)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	CPI  R30,LOW(0xE10)
	LDI  R26,HIGH(0xE10)
	CPC  R31,R26
	BRLO _0x51
; 0000 00F4         {
; 0000 00F5         DDRA.7 = !DDRA.7;
	SBIS 0x1A,7
	RJMP _0x52
	CBI  0x1A,7
	RJMP _0x53
_0x52:
	SBI  0x1A,7
_0x53:
; 0000 00F6          if (time == 3600)
	RCALL SUBOPT_0x4
	CPI  R26,LOW(0xE10)
	LDI  R30,HIGH(0xE10)
	CPC  R27,R30
	BRNE _0x54
; 0000 00F7          {
; 0000 00F8          PORTA.5=0;
	CBI  0x1B,5
; 0000 00F9          DDRA.5=1;
	SBI  0x1A,5
; 0000 00FA          DDRA.7 = 1;
	SBI  0x1A,7
; 0000 00FB          };
_0x54:
; 0000 00FC          if (time > 3650)
	RCALL SUBOPT_0x4
	CPI  R26,LOW(0xE43)
	LDI  R30,HIGH(0xE43)
	CPC  R27,R30
	BRLO _0x5B
; 0000 00FD          {
; 0000 00FE             TIMSK=0x00;
	LDI  R30,LOW(0)
	OUT  0x39,R30
; 0000 00FF             OCR1C=0x10;
	LDI  R30,LOW(16)
	OUT  0x2B,R30
; 0000 0100             PORTA=0b00110001;
	LDI  R30,LOW(49)
	OUT  0x1B,R30
; 0000 0101             DDRA=0b01000001;
	LDI  R30,LOW(65)
	OUT  0x1A,R30
; 0000 0102             while(1)
_0x5C:
; 0000 0103             {
; 0000 0104             delay_ms(200);
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	RCALL SUBOPT_0x0
; 0000 0105             DDRA.7 = 1;
	SBI  0x1A,7
; 0000 0106             delay_ms(100);
	RCALL SUBOPT_0x2
; 0000 0107             DDRA.7 = 0;
	CBI  0x1A,7
; 0000 0108             }
	RJMP _0x5C
; 0000 0109          };
_0x5B:
; 0000 010A         };
_0x51:
; 0000 010B     };
_0x50:
; 0000 010C 
; 0000 010D 
; 0000 010E       };
	RJMP _0x23
; 0000 010F }
_0x63:
	RJMP _0x63
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_adc_noise_red=0x08
	.EQU __sm_mask=0x18
	.EQU __sm_powerdown=0x10
	.EQU __sm_standby=0x18
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG

	.DSEG
_time:
	.BYTE 0x2

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:14 WORDS
SUBOPT_0x0:
	ST   -Y,R31
	ST   -Y,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1:
	LDI  R26,0
	SBRC R2,1
	LDI  R26,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x2:
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	RJMP SUBOPT_0x0

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x3:
	LDI  R30,0
	SBRC R2,4
	LDI  R30,1
	OR   R30,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4:
	LDS  R26,_time
	LDS  R27,_time+1
	RET


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__LTW12U:
	CP   R26,R30
	CPC  R27,R31
	LDI  R30,1
	BRLO __LTW12UT
	CLR  R30
__LTW12UT:
	RET

__GTW12U:
	CP   R30,R26
	CPC  R31,R27
	LDI  R30,1
	BRLO __GTW12UT
	CLR  R30
__GTW12UT:
	RET

;END OF CODE MARKER
__END_OF_CODE:
