
#pragma used+
sfrb ADCL=4;
sfrb ADCH=5;
sfrw ADCW=4;      
sfrb ADCSR=6;
sfrb ADMUX=7;
sfrb ACSR=8;
sfrb USICR=0xd;
sfrb USISR=0xe;
sfrb USIDR=0xf;
sfrb PINB=0x16;
sfrb DDRB=0x17;
sfrb PORTB=0x18;
sfrb PINA=0x19;
sfrb DDRA=0x1a;
sfrb PORTA=0x1b;
sfrb EECR=0x1c;
sfrb EEDR=0x1d;
sfrb EEAR=0x1e;
sfrb WDTCR=0x21;
sfrb PLLCSR=0x29;
sfrb OCR1C=0x2b;
sfrb OCR1B=0x2c;
sfrb OCR1A=0x2d;
sfrb TCNT1=0x2e;
sfrb TCCR1B=0x2f;
sfrb TCCR1A=0x30;
sfrb OSCCAL=0x31;
sfrb TCNT0=0x32;
sfrb TCCR0=0x33;
sfrb MCUSR=0x34;
sfrb MCUCR=0x35;
sfrb TIFR=0x38;
sfrb TIMSK=0x39;
sfrb GIFR=0x3a;
sfrb GIMSK=0x3b;
sfrb SP=0x3d;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_adc_noise_red=0x08
	.EQU __sm_mask=0x18
	.EQU __sm_powerdown=0x10
	.EQU __sm_standby=0x18
	.SET power_ctrl_reg=mcucr
	#endif
#endasm

#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

#pragma used+
void sleep_enable(void);
void sleep_disable(void);
void idle(void);

void powerdown(void);

void standby(void);

#pragma used-

#pragma library sleep.lib

unsigned int m,d,n,a,tok,time;
bit j,k,l,zad,k1;

unsigned int read_adc(unsigned char adc_input)
{
ADMUX=adc_input | (0x80 & 0xff);

delay_us(10);

ADCSR|=0x40;

while ((ADCSR & 0x10)==0);
ADCSR|=0x10;
return ADCW;
}

interrupt [7] void timer0_ovf_isr(void)
{

if(zad++) TCNT0 = 0xC7;        
else
{

TCNT0=0x01;

if (a++<83)
{
if (k&(a<82)) PORTA.0 = !PORTA.0; else PORTA.0 = 0;
}
else
{
PORTA.0 = 1;
};
if (a == 83) 
{
d = read_adc(2);
zad++;
if (d > tok)
{
OCR1C=0x08;
PORTA.6=0;
DDRA.7 = 0;
m = 0;
} else
{
if(m>220)
{
OCR1C=0x08;
DDRA.7 = !DDRA.7;
} else
{
OCR1C=0x60;             
PORTA.6=1;
};
if (m>440) m=0;
m++;
};
};

if (a > n) a = 0;
};
}

void main(void)
{

PORTA=0b00110001;
DDRA=0b11000001;

PORTB=0x00;
DDRB=0x82;

TCCR0=0x01;
TCNT0=0x00;

PLLCSR=0x00;
TCCR1A=0xC2;
TCCR1B=0x82;
TCNT1=0x00;
OCR1A=0x20;                      
OCR1B=0x00;
OCR1C=0x06;                    

GIMSK=0x00;
MCUCR=0x00;

TIMSK=0x00;

USICR=0x00;

ACSR=0x80;

ADMUX=0x80 & 0xff;
ADCSR=0x83;

PORTA.0 = 1;

d = 500;
n = 290;
tok = 25;

#asm("sei")

while (1)
{

delay_ms(290);               
if (n>288) j = 1;
if (n<220) j = 0;
if (j) n--; else n++;
if ((!PINA.4)&(tok<300))
{
if (l) tok = tok + 5;
else
{
if (k&(!k1))
{
PORTB.6=1;
k1=1;
} else
{
if (k1) k=1;
k1=0;
PORTB.6=0;
};
k = !k;
};
};
if ((!PINA.5)&(tok>5))
{
if (l) tok = tok - 5;
else
{
l = 1;
time = 0;
TIMSK=0x02;
};
};
if(!l)
{
delay_ms(200);
DDRA.7 = 1;
PORTA.6 = 1;
delay_ms(100);
DDRA.7 = 0;
PORTA.6 = 0;
delay_ms(100);
DDRA.7 = k|k1;
PORTA.6 = k|k1;
delay_ms(100);
DDRA.7 = 0;
PORTA.6 = 0;
delay_ms(100);
DDRA.7 = k1;
PORTA.6 = k1;
delay_ms(100);
DDRA.7 = 0;
PORTA.6 = 0;
} else
{
if (++time >= 3600)
{
DDRA.7 = !DDRA.7;
if (time == 3600)
{
PORTA.5=0;
DDRA.5=1;
DDRA.7 = 1;
};
if (time > 3650)
{
TIMSK=0x00;
OCR1C=0x10;
PORTA=0b00110001;
DDRA=0b01000001;
while(1)
{
delay_ms(200);
DDRA.7 = 1;
delay_ms(100);
DDRA.7 = 0;
}
};
};
};

};
}
